

#ifndef VALIB_MPEG_DEMUX_H
#define VALIB_MPEG_DEMUX_H

#include "defs.h"
#include "spk.h"
#include "syncscan.h"

class PSParser
{
private: 
  SyncScan scanner;
  enum { state_sync, state_header, state_drop } state;
  size_t data_size;     

public: 
  uint8_t header[268];  
  uint8_t *subheader;   

  size_t  header_size;  
  size_t  payload_size; 

  int stream;           
  int substream;        

  int packets;          
  int errors;           

public: 
  PSParser();

  void   reset();
  size_t parse(uint8_t **buf, uint8_t *end);

  bool is_audio();
  Speakers spk();
};



class PSDemux
{
public: 
  PSParser parser;
  int stream;
  int substream;

public: 
  PSDemux(int stream = 0, int substream = 0);

  void   reset();
  void   set(int stream, int substream = 0);
  size_t demux(uint8_t *buf, size_t size);
};

#endif
