

#ifndef VALIB_MPA_PARSER_H
#define VALIB_MPA_PARSER_H

#include "../../parser.h"
#include "../../bitstream.h"
#include "../../data.h"
#include "mpa_defs.h"
#include "mpa_synth.h"


class MPAParser : public FrameParser
{
public:
  
  union Header
  {
    Header() {};
    Header(uint32_t i) { raw = i; }

    uint32_t raw;
    struct
    {
      unsigned emphasis           : 2;
      unsigned original           : 1;
      unsigned copyright          : 1;
      unsigned mode_ext           : 2;
      unsigned mode               : 2;
      unsigned extension          : 1;
      unsigned padding            : 1;
      unsigned sampling_frequency : 2;
      unsigned bitrate_index      : 4;
      unsigned error_protection   : 1;
      unsigned layer              : 2;
      unsigned version            : 1;
      unsigned sync               : 12;
    };
  };
  
  struct BSI
  {
    int bs_type;    
    int ver;        
    int layer;      
    int mode;       
    int bitrate;    
    int freq;       

    int nch;        
    int nsamples;   
    size_t frame_size; 

    int jsbound;    
    int sblimit;    
  };

  Header   hdr; 
  BSI      bsi; 

  MPAParser();
  ~MPAParser();

  
  

  virtual const HeaderParser *header_parser() const;

  virtual void reset();
  virtual bool parse_frame(uint8_t *frame, size_t size);

  virtual Speakers  get_spk()      const { return spk;          }
  virtual samples_t get_samples()  const { return samples;      }
  virtual size_t    get_nsamples() const { return bsi.nsamples; }
  virtual uint8_t  *get_rawdata()  const { return 0;            }
  virtual size_t    get_rawsize()  const { return 0;            }

  virtual size_t stream_info(char *buf, size_t size) const;
  virtual size_t frame_info(char *buf, size_t size) const;

private:
  Speakers  spk;        
  SampleBuf samples;    
  ReadBS    bs;         

  SynthBuffer *synth[MPA_NCH]; 
  int II_table;         

  
  

  bool parse_header(const uint8_t *frame, size_t size);

  
  

  bool I_decode_frame();
  void I_decode_fraction(
         sample_t *fraction[MPA_NCH], 
         int16_t  bit_alloc[MPA_NCH][SBLIMIT],
         sample_t scale[MPA_NCH][SBLIMIT]);

  
  

  bool II_decode_frame();
  void II_decode_fraction(
         sample_t *fraction[MPA_NCH], 
         int16_t  bit_alloc[MPA_NCH][SBLIMIT],
         sample_t scale[MPA_NCH][3][SBLIMIT],
         int x);
};

#endif
