

#ifndef VALIB_SINK_DSOUND_H
#define VALIB_SINK_DSOUND_H

#include <dsound.h>
#include <mmreg.h>
#include <ks.h>
#include <ksmedia.h>
#include "../filter.h"
#include "../renderer.h"
#include "../win32/thread.h"

class DSoundSink : public Sink, public PlaybackControl
{
protected:
  
  

  HWND     hwnd;
  LPCGUID  device;        
  int      buf_size_ms;   
  int      preload_ms;    

  
  
  

  Speakers spk;           
  DWORD    buf_size;      
  DWORD    preload_size;  
  double   bytes2time;    

  
  

  IDirectSound        *ds;
  IDirectSoundBuffer  *ds_buf;

  
  

  DWORD    cur;           
  vtime_t  time;          
  bool     playing;       
  bool     paused;        

  
  

  mutable CritSec dsound_lock;
  mutable CritSec playback_lock;
  HANDLE  ev_stop;

  
  

  bool open(WAVEFORMATEX *wfx);
  bool try_open(Speakers spk) const;
  bool try_open(WAVEFORMATEX *wf) const;

public:
  DSoundSink();
  ~DSoundSink();

  
  

  bool open_dsound(HWND _hwnd, int buf_size_ms = 2000, int preload_ms = 500, LPCGUID device = 0);
  void close_dsound();

  bool open(Speakers spk);
  void close();

  
  

  virtual void pause();
  virtual void unpause();
  virtual bool is_paused() const;

  virtual void stop();
  virtual void flush();

  virtual vtime_t get_playback_time() const;

  virtual size_t  get_buffer_size()   const;
  virtual vtime_t get_buffer_time()   const;
  virtual size_t  get_data_size()     const;
  virtual vtime_t get_data_time()     const;

  virtual double get_vol()            const;
  virtual void   set_vol(double vol);

  virtual double get_pan()            const;
  virtual void   set_pan(double pan);

  
  

  virtual bool query_input(Speakers _spk) const;
  virtual bool set_input(Speakers _spk);
  virtual Speakers get_input() const;
  virtual bool process(const Chunk *_chunk);
};

#endif
