#ifndef VALIB_SINK_WAV
#define VALIB_SINK_WAV

#include "../filter.h"
#include "../auto_file.h"

class WAVSink : public Sink
{
protected:
  AutoFile f;
  Speakers spk;

  uint32_t header_size;  
  uint32_t data_size;    
  uint8_t *file_format;  

public:
  WAVSink();
  WAVSink(const char *file_name);
  ~WAVSink();

  bool open(const char *file_name);
  void close();
  bool is_open() const;

  
  

  virtual bool query_input(Speakers _spk) const;
  virtual bool set_input(Speakers _spk);
  virtual Speakers get_input() const;
  virtual bool process(const Chunk *_chunk); 
};

#endif
