

#ifndef VALIB_CPU_H
#define VALIB_CPU_H

#include <windows.h>
#include "../vtime.h"

class CPUMeter
{
private:
  int      ncpus;             
  HANDLE   thread;            
  __int64  thread_time;       
  __int64  system_time_begin; 
  __int64  thread_time_begin; 
  __int64  thread_time_total; 

  __int64  system_time_start; 
  __int64  system_time_total; 

public:
  CPUMeter();

  
  void    start();  
  void    stop();   

  
  

  void    reset();  
  double  usage();  
                    

  vtime_t get_thread_time();    
  vtime_t get_system_time();    
  int     get_number_of_cpus(); 

  
  
  double  mean_usage() { return get_thread_time() / get_system_time(); };
};

#endif
