/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoTooL.h"


CConvert::CConvert(int nContainerType, HRESULT *phr)
{

   m_pConvert = NULL;
   m_nContainerType = nContainerType;

   try
   {
      switch(nContainerType)
      {
      case CONTAINER_WAV:
         m_pConvert = new CConvertToWav();
         break;
      case CONTAINER_AAC:
         m_pConvert = new CConvertToAac();
         break;
      case CONTAINER_MP3_FRAUNHOFER:
         m_pConvert = new CConvertToMp3Fraunhofer();
         break;
      case CONTAINER_MP3_LAME:
         m_pConvert = new CConvertToMp3Lame();
         break;
      case CONTAINER_OGG:
         m_pConvert = new CConvertToOgg();
         break;
      case CONTAINER_RAW:
         m_pConvert = new CConvertRaw();
         break;
      }

      if(phr != NULL)
         *phr = S_OK;
   }
   catch(std::bad_alloc & e)
   {
      m_pConvert = NULL;

      if(phr != NULL)
         *phr = E_FAIL;
   }
}

CConvert::~CConvert()
{
   if(m_pConvert == NULL)
      return;

   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      delete (CConvertToWav *)m_pConvert;
      break;
   case CONTAINER_AAC:
      delete (CConvertToAac *)m_pConvert;
      break;
   case CONTAINER_MP3_FRAUNHOFER:
      delete (CConvertToMp3Fraunhofer *)m_pConvert;
      break;
   case CONTAINER_MP3_LAME:
      delete (CConvertToMp3Lame *)m_pConvert;
      break;
   case CONTAINER_OGG:
      delete (CConvertToOgg *)m_pConvert;
      break;
   case CONTAINER_RAW:
      delete (CConvertRaw *)m_pConvert;
      break;
   }
}

void CConvert::GetFormat(WCHAR *pwInputFormat, WCHAR *pwOutputFormat)
{
   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      return ((CConvertToWav *)m_pConvert)->GetFormat(pwInputFormat, pwOutputFormat);
   case CONTAINER_AAC:
      return ((CConvertToAac *)m_pConvert)->GetFormat(pwInputFormat, pwOutputFormat);
   case CONTAINER_MP3_FRAUNHOFER:
      return ((CConvertToMp3Fraunhofer *)m_pConvert)->GetFormat(pwInputFormat, pwOutputFormat);
   case CONTAINER_MP3_LAME:
      return ((CConvertToMp3Lame *)m_pConvert)->GetFormat(pwInputFormat, pwOutputFormat);
   case CONTAINER_OGG:
      return ((CConvertToOgg *)m_pConvert)->GetFormat(pwInputFormat, pwOutputFormat);
   case CONTAINER_RAW:
      return ((CConvertRaw *)m_pConvert)->GetFormat(pwInputFormat, pwOutputFormat);
   }
}

int CConvert::GraphNotify(void)
{
   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      return ((CConvertToWav *)m_pConvert)->GraphNotify();
   case CONTAINER_AAC:
      return ((CConvertToAac *)m_pConvert)->GraphNotify();
   case CONTAINER_MP3_FRAUNHOFER:
      return ((CConvertToMp3Fraunhofer *)m_pConvert)->GraphNotify();
   case CONTAINER_MP3_LAME:
      return ((CConvertToMp3Lame *)m_pConvert)->GraphNotify();
   case CONTAINER_OGG:
      return ((CConvertToOgg *)m_pConvert)->GraphNotify();
   case CONTAINER_RAW:
      return ((CConvertRaw *)m_pConvert)->GraphNotify();
   }

   return -1;
}

HRESULT CConvert::WriteAlbumGain(WCHAR *pwFileName, WCHAR *pwOutputFolder, double dAlbumPeak, double dAlbumGain)
{
   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      return ((CConvertToWav *)m_pConvert)->WriteAlbumGain(pwFileName, pwOutputFolder, dAlbumPeak, dAlbumGain);
   case CONTAINER_MP3_FRAUNHOFER:
      return ((CConvertToMp3Fraunhofer *)m_pConvert)->WriteAlbumGain(pwFileName, pwOutputFolder, dAlbumPeak, dAlbumGain);
   case CONTAINER_MP3_LAME:
      return ((CConvertToMp3Lame *)m_pConvert)->WriteAlbumGain(pwFileName, pwOutputFolder, dAlbumPeak, dAlbumGain);
   case CONTAINER_OGG:
      return ((CConvertToOgg *)m_pConvert)->WriteAlbumGain(pwFileName, pwOutputFolder, dAlbumPeak, dAlbumGain);
   }

   return E_FAIL;
}

int CConvert::ConvertStart(HWND hWnd, WCHAR *pwInputFileName, WCHAR *pwOutputFolder, CONVERTDATA2 *pConvertData, int nWait)
{
   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      return ((CConvertToWav *)m_pConvert)->ConvertStart(hWnd, pwInputFileName, pwOutputFolder, pConvertData, nWait);
   case CONTAINER_AAC:
      return ((CConvertToAac *)m_pConvert)->ConvertStart(hWnd, pwInputFileName, pwOutputFolder, pConvertData, nWait);
   case CONTAINER_MP3_FRAUNHOFER:
      return ((CConvertToMp3Fraunhofer *)m_pConvert)->ConvertStart(hWnd, pwInputFileName, pwOutputFolder, pConvertData, nWait);
   case CONTAINER_MP3_LAME:
      return ((CConvertToMp3Lame *)m_pConvert)->ConvertStart(hWnd, pwInputFileName, pwOutputFolder, pConvertData, nWait);
   case CONTAINER_OGG:
      return ((CConvertToOgg *)m_pConvert)->ConvertStart(hWnd, pwInputFileName, pwOutputFolder, pConvertData, nWait);
   case CONTAINER_RAW:
      return ((CConvertRaw *)m_pConvert)->ConvertStart(hWnd, pwInputFileName, pwOutputFolder, pConvertData, nWait);
   }

   return -1;
}

int CConvert::Converting(int *pnPercent)
{

   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      return ((CConvertToWav *)m_pConvert)->Converting(pnPercent);
   case CONTAINER_AAC:
      return ((CConvertToAac *)m_pConvert)->Converting(pnPercent);
   case CONTAINER_MP3_FRAUNHOFER:
      return ((CConvertToMp3Fraunhofer *)m_pConvert)->Converting(pnPercent);
   case CONTAINER_MP3_LAME:
      return ((CConvertToMp3Lame *)m_pConvert)->Converting(pnPercent);
   case CONTAINER_OGG:
      return ((CConvertToOgg *)m_pConvert)->Converting(pnPercent);
   case CONTAINER_RAW:
      return ((CConvertRaw *)m_pConvert)->Converting(pnPercent);
   }

   return -1;
}

int CConvert::ConvertEnd(CONVERTDATA2 *pConvertData)
{
   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      return ((CConvertToWav *)m_pConvert)->ConvertEnd(pConvertData);
   case CONTAINER_AAC:
      return ((CConvertToAac *)m_pConvert)->ConvertEnd(pConvertData);
   case CONTAINER_MP3_FRAUNHOFER:
      return ((CConvertToMp3Fraunhofer *)m_pConvert)->ConvertEnd(pConvertData);
   case CONTAINER_MP3_LAME:
      return ((CConvertToMp3Lame *)m_pConvert)->ConvertEnd(pConvertData);
   case CONTAINER_OGG:
      return ((CConvertToOgg *)m_pConvert)->ConvertEnd(pConvertData);
   case CONTAINER_RAW:
      return ((CConvertRaw *)m_pConvert)->ConvertEnd(pConvertData);
   }

   return -1;
}

void CConvert::ConvertExit(void)
{
   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      ((CConvertToWav *)m_pConvert)->ConvertExit();
      break;
   case CONTAINER_AAC:
      ((CConvertToAac *)m_pConvert)->ConvertExit();
      break;
   case CONTAINER_MP3_FRAUNHOFER:
      ((CConvertToMp3Fraunhofer *)m_pConvert)->ConvertExit();
      break;
   case CONTAINER_MP3_LAME:
      ((CConvertToMp3Lame *)m_pConvert)->ConvertExit();
      break;
   case CONTAINER_OGG:
      ((CConvertToOgg *)m_pConvert)->ConvertExit();
      break;
   case CONTAINER_RAW:
      ((CConvertRaw *)m_pConvert)->ConvertExit();
      break;
   }
}

void CConvert::SetWait(int nWait)
{
   switch(m_nContainerType)
   {
   case CONTAINER_WAV:
      ((CConvertToWav *)m_pConvert)->SetWait(nWait);
      break;
   case CONTAINER_AAC:
      ((CConvertToAac *)m_pConvert)->SetWait(nWait);
      break;
   case CONTAINER_MP3_FRAUNHOFER:
      ((CConvertToMp3Fraunhofer *)m_pConvert)->SetWait(nWait);
      break;
   case CONTAINER_MP3_LAME:
      ((CConvertToMp3Lame *)m_pConvert)->SetWait(nWait);
      break;
   case CONTAINER_OGG:
      ((CConvertToOgg *)m_pConvert)->SetWait(nWait);
      break;
   case CONTAINER_RAW:
      ((CConvertRaw *)m_pConvert)->SetWait(nWait);
      break;
   }
}

