/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#ifndef _CEncodeLame_h_
#define _CEncodeLame_h_

#include "BladeMP3EncDLL.h"


typedef struct
{
   int nMode;
   int nQuality;

   int nCbrBitarte;

   int nVbrQuality;
   int nVbrMinBitrate;
   int nVbrMaxBitrate;

} LAME_CONFIG, *PLAME_CONFIG;

class CEncodeLame
{
public:

   
   CEncodeLame();
   ~CEncodeLame();

   
   HRESULT SetInFormat(WAVEFORMATEX *);
   HRESULT SetOutFormat(LAME_CONFIG *);
   HRESULT CheckOutFormat(WAVEFORMATEX *, LAME_CONFIG *);

   HRESULT EncodeInit(int);
   HRESULT Receive(HANDLE, IMediaSample *);
   HRESULT EncodeEnd(HANDLE, WCHAR *);

   void WriteHeader(WCHAR *);

private:

   
   void LameRelease(void);
   void SetConfig(BE_CONFIG *, LAME_CONFIG *, WAVEFORMATEX *);

   
   HMODULE m_hDLL;
   HBE_STREAM m_hbeStream;
   BE_CONFIG m_beConfig;
   PBYTE m_pMP3Buffer;
   int m_nMaxBuffer;
   int m_nCurrentPos;

   BEINITSTREAM     beInitStream;
   BEENCODECHUNK    beEncodeChunk;
   BEDEINITSTREAM   beDeinitStream;
   BECLOSESTREAM    beCloseStream;
   BEWRITEVBRHEADER beWriteVBRHeader;
   BEWRITEINFOTAG   beWriteInfoTag;

   WAVEFORMATEX m_inFormat;
   LAME_CONFIG m_outFormat;
};


#endif _CEncodeLame_h_
