package org.blueforest.rockhouse.encoding_converter.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.blueforest.rockhouse.encoding_converter.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.Workbench;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ConvertAction implements IObjectActionDelegate {

	private Shell shell;
	private ISelection selection = null;
	private MessageConsoleStream consoleCache = null;
	private static String CONSOLE_ID = "Encoding Converter";
	
	/**
	 * Constructor for Action1.
	 */
	public ConvertAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		try {
			if (selection == null || selection.isEmpty()) return;
	
			if (!(selection instanceof IStructuredSelection)) {
				return;
			}

			Charset charset = this.actionIdToCharset(action);
			IStructuredSelection structuredSelection = (IStructuredSelection)selection;
			for (@SuppressWarnings("rawtypes")
			Iterator it = (Iterator)structuredSelection.iterator(); it.hasNext();) {

				run(it.next(), charset);
			}

		} catch (CoreException e) {
			e.printStackTrace();
		}
	}
	
	private Charset actionIdToCharset(IAction action) {
		String id = action.getId();
		if (id.contains(".to_utf-8")) {
			return Charset.forName("UTF-8");
		} else if (id.contains(".to_project_default")) {
			return null;
		} else {
			throw new IllegalArgumentException("unknown action id. id=" + action.getId());
		}
	}

	private void printConsole(String message) throws CoreException {
		if (this.consoleCache == null) {
			this.consoleCache = getConsoleWriter();
		}
		this.consoleCache.print(message);
		try {
			this.consoleCache.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	private MessageConsoleStream getConsoleWriter() throws CoreException {
		MessageConsole console = this.findConsole();
		IConsoleView view = (IConsoleView) Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(IConsoleConstants.ID_CONSOLE_VIEW);
		view.display(console);
		return console.newMessageStream();
	}
	
	private MessageConsole findConsole() {
		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		for (IConsole console : manager.getConsoles()) {
			if (console.getName().equals(CONSOLE_ID))
				return (MessageConsole)console;
		}
		
		MessageConsole console = new MessageConsole(CONSOLE_ID, null);
		manager.addConsoles(new IConsole[]{console});
		return console;
	}

	
	
	private void run(Object selection, Charset charset) throws CoreException {
		try {
			if (!(selection instanceof IFile)) {
				return;
			}
			
			IFile file = (IFile)selection;
			this.printConsole(file.getFullPath().toPortableString() + ": ");

			if (!file.isAccessible()) {
				this.printConsole("skipped. this file is not accessible file.\n");
				return;
			}

			if (file.isPhantom()) {
				this.printConsole("skipped. this file is phantom file.\n");
				return;
			}

			if (file.isReadOnly()) {
				this.printConsole("skipped. this file is read-only file.\n");
				return;
			}

			if (!file.isSynchronized(0)) {
				this.printConsole("skipped. this file is not synchronized.\n");
				return;
			}
						
			String fromCharsetName = file.getCharset();
			String toCharsetName = null;
			if (charset == null) {
				toCharsetName = file.getProject().getDefaultCharset();
			} else {
				toCharsetName = charset.name();
			}
			this.printConsole(fromCharsetName + "->" + toCharsetName + " ");

			if (fromCharsetName.equals(toCharsetName)) {
				this.printConsole("skipped. charset is equals.\n");
				return;
			}
			
			Reader is = new InputStreamReader(file.getContents(), fromCharsetName);
			
			CharArrayWriter os = new CharArrayWriter();
			do {
				int c = is.read();
				if (c == -1) break;
				os.write(c);
			} while (true);
			is.close();
			
			InputStream convertedInStream = new ByteArrayInputStream(os.toString().getBytes(toCharsetName));
			file.setContents(convertedInStream, 0, null);
			file.setCharset((charset==null)?null:toCharsetName, null);

			this.printConsole("success.\n");
			
		} catch (IOException e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, "", e);
			throw new CoreException(status);
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

}
