/**
 * 
 */
package org.blueforest.rockhouse.encoding_converter.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.blueforest.rockhouse.encoding_converter.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;

/**
 * @author akira saito
 *
 */
public class ConvertNewlineAction extends ConvertAction {

	/**
	 * 
	 */
	public ConvertNewlineAction() {
		// TODO Auto-generated constructor stub
	}
	
	@Override
	protected boolean convert(IAction action, IFile file) throws CoreException {
		try {
			NewlineCode newline = this.actionIdToNewlineChar(action);

			InputStream istream = file.getContents();
			byte[] convertedBytes = convertNewline(istream, newline);
			if (convertedBytes != null) {
				InputStream convertedIstream = new ByteArrayInputStream(convertedBytes);
				file.setContents(convertedIstream, 0, null);
				return true;
			} else {
				return false;
			}
			
		} catch (IOException e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, "", e);
			throw new CoreException(status);
		}
	}
	
	private NewlineCode actionIdToNewlineChar(IAction action) {
		String id = action.getId();
		if (id.contains(".to_lf")) {
			return NewlineCode.LF;
		} else if (id.contains(".to_crlf")) {
			return NewlineCode.CRLF;
		} else if (id.contains(".to_cr")) {
			return NewlineCode.CR;
		} else {
			throw new IllegalArgumentException("unknown action id. id=" + action.getId());
		}
	}

	public byte[] convertNewline(InputStream bytes, NewlineCode newline) throws IOException, CoreException {
//		PushbackInputStream is = new PushbackInputStream(bytes);
//		ByteArrayOutputStream os = new ByteArrayOutputStream();
//		byte[] newlineCode = newline.getBytes();
//		boolean detectCr, detectLf, detectCrLf;
//		detectCr = detectLf = detectCrLf = false;
//
//		int c = 0;
//		int prev = 0;
//		do {
//			prev = c;
//			c = is.read();
//			if (c == -1) break;
//			
//			if (c == '\r') {
//				int next = is.read();
//				is.unread(next);
//				
//				if (next == -1) {
//					os.write(newlineCode);
//					detectCr = true;
//					break;
//				} else if (next == '\n') {
//					detectCrLf = true;
//					continue;
//				} else {
//					os.write(newlineCode);
//					detectCr = true;
//					continue;
//				}
//				
//			} else if (c == '\n') {
//				os.write(newlineCode);
//				if (prev != '\r') {
//					detectLf = true;
//				}
//				continue;
//			}
//			
//			os.write(c);
//		} while (true);
//		is.close();
		
		NewlineConvertInputStream is = new NewlineConvertInputStream(bytes, newline);
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		while (true) {
			int c = is.read();
			if (c == -1) {
				break;
			}
			os.write(c);
		}
		is.close();
		
		List<String> detectedCodes = new ArrayList<String>();
		if (is.hasCr()) {
			detectedCodes.add("CR");
		}
		if (is.hasLf()) {
			detectedCodes.add("LF");
		}
		if (is.hasCrLf()) {
			detectedCodes.add("CRLF");
		}
		StringBuilder builder = new StringBuilder();
		for (String detectedCode : detectedCodes) {
			builder.append(detectedCode).append(',');
		}
		if (builder.length()>0) {
			this.printConsole(builder.substring(0, builder.length()-1) + "->" + newline.name() + " ");
			return os.toByteArray();
		} else {
			this.printConsole("no have newline characters.");
			return null;
		}
		
	}
}
