/**
 * 
 */
package org.blueforest.rockhouse.encoding_converter.popup.actions;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;

/**
 * @author akira saito
 *
 */
public class NewlineConvertInputStream extends InputStream {
	private InputStream stream;
	private IntBuffer buffer;
	private NewlineCode newline;
	private int[] newlineCode;
	private boolean cr = false;
	private boolean lf = false;
	private boolean crLf = false;
	private boolean reachEof = false;
	
	/**
	 * 
	 */
	public NewlineConvertInputStream(InputStream stream, NewlineCode newline) {
		this.stream = stream;
		this.buffer = IntBuffer.allocate(4096);
		this.buffer.limit(0);
		this.newline = newline;

		byte[] bytes = this.newline.getBytes();
		this.newlineCode = new int[bytes.length];
		for (int i = 0; i < bytes.length; ++i) {
			this.newlineCode[i] = bytes[i];
		}
	}

	private void charge() throws IOException {
		this.buffer.clear();

		do {
			int c = this.stream.read();
			if (c == -1) {
				this.buffer.put(-1);
				break;
			}
			
			if (c == '\r') {
				int next = this.stream.read();
				if (next == -1) {
					this.buffer.put(this.newlineCode);
					cr = true;
					break;
					
				} else if (next == '\n') {
					this.buffer.put(this.newlineCode);
					crLf = true;
					continue;

				} else {
					this.buffer.put(this.newlineCode);
					this.buffer.put(next);
					cr = true;
					continue;
				}
				
			} else if (c == '\n') {
				this.buffer.put(this.newlineCode);
				lf = true;
				continue;
			}
			
			this.buffer.put(c);
			
		} while (this.buffer.remaining() >= newlineCode.length + 1);

		this.buffer.limit(this.buffer.position());
		this.buffer.rewind();
	}
	
	@Override
	public int read() throws IOException {
		if (this.reachEof) {
			throw new EOFException();
		}
		
		if (!this.buffer.hasRemaining()) {
			this.charge();
		}

		int c = this.buffer.get();
		if (c == -1) {
			this.reachEof = true;
		}
		return c;
	}

	@Override
	public int read(byte[] b) throws IOException {
		int i;
		for (i = 0; i < b.length; ++i) {
			int c = this.read();
			if (c == -1) {
				break;
			}
			b[i] = (byte)c;
		}
		return i;
	}

	@Override
	public int read(byte[] b, int off, int len) throws IOException {
		int i;
		for (i = 0; i < len; ++i) {
			int c = this.read();
			if (c == -1) {
				break;
			}
			b[i+off] = (byte)c;
		}
		return i;
	}

	@Override
	public int available() throws IOException {
		return this.stream.available() + this.buffer.remaining();
	}

	@Override
	public long skip(long n) throws IOException {
		return this.stream.skip(n);
	}

	@Override
	public boolean markSupported() {
		return false;
	}

	@Override
	public void mark(int readlimit) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void reset() throws IOException {
		throw new UnsupportedOperationException();
	}

	@Override
	public void close() throws IOException {
		this.stream.close();
	}

	public boolean hasCr() {
		return this.cr;
	}

	public boolean hasLf() {
		return this.lf;
	}

	public boolean hasCrLf() {
		return this.crLf;
	}

}
