package org.blueforest.rockhouse.encoding_converter.popup.actions.wizard;

import java.nio.charset.Charset;

import org.blueforest.rockhouse.encoding_converter.popup.actions.ConvertEncodingParameter;
import org.eclipse.jface.wizard.Wizard;

public class ConvertEncodingWizard extends Wizard {
	private ConvertEncodingWizardPage page1 = new ConvertEncodingWizardPage();
	private ConvertEncodingParameter convertParameter = new ConvertEncodingParameter();

	public ConvertEncodingWizard() {
	}

	@Override
	public boolean performFinish() {
		String fromEncoding = this.getFromEncoding();
		if (fromEncoding != null) {
			fromEncoding = fromEncoding.trim();
			if(fromEncoding.length()==0) {
				page1.setErrorMessage("From encoding is empty.");
				return false;
			}
			if(!Charset.isSupported(fromEncoding)) {
				page1.setErrorMessage("From encoding is not supported.");
				return false;
			}
		}

		String toEncoding = this.getToEncoding();
		if (toEncoding != null) {
			toEncoding = toEncoding.trim();
			if(toEncoding.length()==0) {
				page1.setErrorMessage("To encoding is empty.");
				return false;
			}
			if(!Charset.isSupported(toEncoding)) {
				page1.setErrorMessage("To encoding is not supported.");
				return false;
			}
		}

		convertParameter = new ConvertEncodingParameter();
		convertParameter.setFromEncoding(fromEncoding);
		convertParameter.setToEncoding(toEncoding);
		convertParameter.setOnlyReportCurrentEncoding(page1.isOnlyReporting());
		return true;
	}

	@Override
	public void addPages() {
		super.addPages();
		
		this.addPage(page1);
	}
	
	public String getFromEncoding() {
		return page1.getFromEncoding();
	}

	public String getToEncoding() {
		return page1.getToEncoding();
	}

	public ConvertEncodingParameter getConvertParameter() {
		return this.convertParameter;
	}

	public void setConvertParameter(ConvertEncodingParameter convertParameter) {
		this.convertParameter = convertParameter;
	}
}
