package org.blueforest.rockhouse.encoding_converter.popup.actions.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class ConvertEncodingWizardPage extends WizardPage {
	private String fromEncoding;
	private String toEncoding;
	private boolean onlyReporting;
	private Button useResourceSettingCheckBox = null;
	private Button useProjectDefaultSettingCheckBox = null;
	private Combo fromEncodingCombo = null;
	private Combo toEncodingCombo = null;
	private Button onlyReportingCheckbox = null;
	
	public ConvertEncodingWizardPage() {
		super("Convert Encoding");
		this.setTitle("Convert Encoding");
		this.setMessage("Run custom conversion.");
		this.setPageComplete(true);
	}
	
	public ConvertEncodingWizardPage(String name) {
		super(name);
	}

	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		container.setLayout(this.createListLayout());
		
		Composite fromToContainer = new Composite(container, SWT.NULL);
		fromToContainer.setLayout(this.createHorizontalFillLayout());

		// From Encoding
		final Group fromEncodingGroup = createGroup(fromToContainer, "From Encoding"); 
		{
			useResourceSettingCheckBox = new Button(fromEncodingGroup, SWT.CHECK);
			useResourceSettingCheckBox.setText("Use resource properties");
			useResourceSettingCheckBox.setSelection(true);
			
			fromEncodingCombo = new Combo(fromEncodingGroup, SWT.DROP_DOWN);
			fromEncodingCombo.setSize(400, fromEncodingCombo.getItemHeight());
			fromEncodingCombo.setEnabled(false);
			fromEncodingCombo.add("UTF-8");

			useResourceSettingCheckBox.addSelectionListener(new SelectionListener(){
				public void widgetSelected(SelectionEvent e) {
//					Button button = (Button)e.widget;
//					if(button.getSelection()) {
//						fromEncodingCombo.setEnabled(false);
//						fromEncoding = null;
//					} else {
//						fromEncodingCombo.setEnabled(true);
//						fromEncoding = fromEncodingCombo.getText();
//					}
					applyInputFieldRule();
				}

				public void widgetDefaultSelected(SelectionEvent e) {
				}
				
			});
		
			fromEncodingCombo.addModifyListener( new ModifyListener() {
				public void modifyText(ModifyEvent e) {
//					fromEncoding = fromEncodingCombo.getText();
					applyInputFieldRule();
				}
			});
		}

		// To Encoding
		final Group toEncodingGroup = createGroup(fromToContainer, "To Encoding");
		{
			useProjectDefaultSettingCheckBox = new Button(toEncodingGroup, SWT.CHECK);
			useProjectDefaultSettingCheckBox.setText("Use project default");
			useProjectDefaultSettingCheckBox.setSelection(true);

			toEncodingCombo = new Combo(toEncodingGroup, SWT.DROP_DOWN);
			toEncodingCombo.setEnabled(false);
			toEncodingCombo.add("UTF-8");
			
			useProjectDefaultSettingCheckBox.addSelectionListener(new SelectionListener(){
				public void widgetSelected(SelectionEvent e) {
//					Button button = (Button)e.widget;
//					if(button.getSelection()) {
//						toEncodingCombo.setEnabled(false);
//						toEncoding = null;
//					} else {
//						toEncodingCombo.setEnabled(true);
//						toEncoding = toEncodingCombo.getText();
//					}
					applyInputFieldRule();
				}

				public void widgetDefaultSelected(SelectionEvent e) {
				}
				
			});

			toEncodingCombo.addModifyListener( new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					applyInputFieldRule();
				}
			});
		}

		// only reporting
		onlyReportingCheckbox = new Button(container, SWT.CHECK);
		onlyReportingCheckbox.setText("Only the current encoding report");
		onlyReportingCheckbox.setSelection(false);
		onlyReportingCheckbox.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				applyInputFieldRule();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
			
		});

		
		this.setControl(fromToContainer);
	}
	
	private void applyInputFieldRule() {
		if (this.onlyReportingCheckbox.getSelection()) {
			onlyReporting = true;
			toEncoding = null;
			fromEncoding = null;
			useResourceSettingCheckBox.setEnabled(false);
			useProjectDefaultSettingCheckBox.setEnabled(false);
			fromEncodingCombo.setEnabled(false);
			toEncodingCombo.setEnabled(false);
			return;
		}
		
		onlyReporting = false;
		useResourceSettingCheckBox.setEnabled(true);
		if (this.useResourceSettingCheckBox.getSelection()) {
			fromEncodingCombo.setEnabled(false);
			fromEncoding = null;
		} else {
			fromEncodingCombo.setEnabled(true);
			fromEncoding = this.fromEncodingCombo.getText();
		}
		
		useProjectDefaultSettingCheckBox.setEnabled(true);
		if (this.useProjectDefaultSettingCheckBox.getSelection()) {
			toEncodingCombo.setEnabled(false);
			toEncoding = null;
		} else {
			toEncodingCombo.setEnabled(true);
			toEncoding = this.toEncodingCombo.getText();
		}
	}

	private FillLayout createHorizontalFillLayout() {
		FillLayout layout = new FillLayout();
		layout.type = SWT.HORIZONTAL;
		return layout;
	}

	private RowLayout createListLayout() {
		RowLayout layout = new RowLayout();
		layout.justify = false;
		layout.type = SWT.VERTICAL;
		layout.fill = true;
		return layout;
	}

	private Group createGroup(Composite container, String caption) {
		Group group = new Group(container, SWT.SHADOW_ETCHED_IN); 
		group.setText(caption);
		group.setLayout(this.createListLayout());
		return group;
	}

	public String getFromEncoding() {
		return this.fromEncoding;
	}

	public void setFromEncoding(String fromEncoding) {
		this.fromEncoding = fromEncoding;
	}

	public String getToEncoding() {
		return this.toEncoding;
	}

	public void setToEncoding(String toEncoding) {
		this.toEncoding = toEncoding;
	}

	public boolean isOnlyReporting() {
		return this.onlyReporting;
	}

	public void setOnlyReporting(boolean onlyReporting) {
		this.onlyReporting = onlyReporting;
	}

}
