/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors;

import jp.sourceforge.ecurlipse.editor.CurlEditorPlugin;
import jp.sourceforge.ecurlipse.editor.editors.CurlColorManager;
import jp.sourceforge.ecurlipse.editor.editors.CurlContentAssistProcessor;
import jp.sourceforge.ecurlipse.editor.editors.CurlDoubleClickStrategy;
import jp.sourceforge.ecurlipse.editor.editors.NonRuleBasedDamagerRepairer;
import jp.sourceforge.ecurlipse.editor.editors.def.DefaultEditorColor;
import jp.sourceforge.ecurlipse.editor.editors.scanner.CurlScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class CurlSourceViewerConfiguration
extends SourceViewerConfiguration {
    private CurlColorManager colorManager;
    private CurlScanner scanner;
    private CurlDoubleClickStrategy doubleClickStrategy;
    private IPreferenceStore preferenceStore;

    public CurlSourceViewerConfiguration(CurlColorManager curlColorManager) {
        this.colorManager = curlColorManager;
        this.preferenceStore = CurlEditorPlugin.getDefault().getPreferenceStore();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__curl_comment"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new CurlDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected CurlScanner getCurlScanner() {
        if (this.scanner == null) {
            this.scanner = new CurlScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(DefaultEditorColor.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCurlScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        RGB commentRGB = StringConverter.asRGB((String)this.preferenceStore.getString("jp.sourceforge.ecurlipse.editor.CommentColor"));
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(commentRGB)));
        reconciler.setDamager((IPresentationDamager)ndr, "__curl_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__curl_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        CurlContentAssistProcessor processor = new CurlContentAssistProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.enableAutoInsert(true);
        return assistant;
    }
}

