/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors.rule;

import jp.sourceforge.ecurlipse.editor.editors.CurlWhitespaceDetector;
import jp.sourceforge.ecurlipse.editor.editors.rule.RuleUtil;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.Assert;

public class CurlClassNameRule
implements IRule {
    private IToken fToken;

    public CurlClassNameRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        CurlWhitespaceDetector detector = new CurlWhitespaceDetector();
        StringBuffer sb = new StringBuffer();
        char c = (char)scanner.read();
        if (RuleUtil.isAlphabet(c) || c == '_') {
            scanner.unread();
            scanner.unread();
            c = (char)scanner.read();
            if (RuleUtil.isCurlWordChar(c)) {
                return Token.UNDEFINED;
            }
            c = (char)scanner.read();
            if (!Character.isUpperCase(c)) {
                scanner.unread();
                return Token.UNDEFINED;
            }
            scanner.unread();
            scanner.unread();
            c = (char)scanner.read();
            if (!detector.isWhitespace(c) && c != '{' && c != ',' && c != '#' && c != ':') {
                return Token.UNDEFINED;
            }
            c = (char)scanner.read();
            while (RuleUtil.isCurlWordChar(c)) {
                sb.append(c);
                c = (char)scanner.read();
            }
            if (RuleUtil.isRightChar(c)) {
                scanner.unread();
            }
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

