/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.model;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jp.sourceforge.edocbook.model.DocbookFile;
import jp.sourceforge.edocbook.model.DocbookTransformer;
import jp.sourceforge.edocbook.model.ResultFile;
import jp.sourceforge.edocbook.model.XslBuilder;

public class DocbookXsl {
    private Properties outputProperties;
    private Map<String, String> parameters;
    private String rootDir;
    private List<String> importXslList = new ArrayList<String>();
    private Map<String, String> templateList = new HashMap<String, String>();
    private String resultFileExtension;

    public DocbookXsl(String rootDir, Properties outputProperties, Map<String, String> parameters) {
        this.rootDir = rootDir;
        this.outputProperties = outputProperties;
        this.parameters = parameters;
    }

    private Source getSource() {
        XslBuilder builder = new XslBuilder();
        for (String string : this.importXslList) {
            builder.addImport(string);
        }
        for (Map.Entry entry : this.templateList.entrySet()) {
            builder.addTemplate((String)entry.getKey(), (String)entry.getValue());
        }
        return new StreamSource(new ByteArrayInputStream(builder.getXslString().getBytes()), this.rootDir);
    }

    public void addImport(String importXsl) {
        this.importXslList.add(importXsl);
    }

    public void addTemplate(String name, String body) {
        this.templateList.put(name, body);
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ResultFile apply(DocbookFile docbook) {
        DocbookTransformer transformer = new DocbookTransformer(this.getSource());
        for (Map.Entry<Object, Object> entry : this.outputProperties.entrySet()) {
            transformer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.parameters.entrySet()) {
            transformer.setParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return transformer.transform(docbook, this.resultFileExtension);
    }

    public String getResultFileExtension() {
        return this.resultFileExtension;
    }

    public void setResultFileExtension(String resultFileExtension) {
        this.resultFileExtension = resultFileExtension;
    }
}

