/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.model;

public class XslBuilder {
    private StringBuilder builder = new StringBuilder();

    public XslBuilder() {
        this.reset();
    }

    public void reset() {
        this.builder.delete(0, this.builder.length());
        this.builder.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:exsl=\"http://exslt.org/common\" version=\"1.0\" exclude-result-prefixes=\"exsl\">");
    }

    public void addImport(String href) {
        this.builder.append("<xsl:import href=\"" + this.escape(href) + "\"/>");
    }

    public void addTemplate(String name, String body) {
        this.builder.append("<xsl:template name=\"" + name + "\">");
        this.builder.append(this.escape(body));
        this.builder.append("</xsl:template> ");
    }

    public String getXslString() {
        return String.valueOf(this.builder.toString()) + "</xsl:stylesheet>";
    }

    private String escape(String source) {
        return source.replace("\"", "\\\"");
    }
}

