/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.popup.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.sourceforge.edocbook.Activator;
import jp.sourceforge.edocbook.EDocbookRuntimeException;
import jp.sourceforge.edocbook.model.DocbookFile;
import jp.sourceforge.edocbook.model.DocbookXsl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractHtmlCreateAction
implements IObjectActionDelegate {
    private IWorkbenchPart part;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    private IFile getSelection() {
        ISelectionProvider selectionProvider = this.part.getSite().getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selectionProvider.getSelection();
            if (!(structuredSelection.getFirstElement() instanceof IResource)) {
                return null;
            }
            IResource resource = (IResource)structuredSelection.getFirstElement();
            if (resource == null || resource.getType() != 1) {
                return null;
            }
            return (IFile)resource;
        }
        if (this.part instanceof IEditorPart) {
            Object obj = ((IEditorPart)this.part).getEditorInput().getAdapter(IFile.class);
            if (obj == null) {
                System.out.println("obj is null.");
                return null;
            }
            return (IFile)obj;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected DocbookFile getSourceFile() {
        IFile iFile = this.getSelection();
        if (iFile != null) {
            return new DocbookFile(iFile.getLocation().toString());
        }
        return null;
    }

    protected void reflesh() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.showErrorDialog(e);
            throw new EDocbookRuntimeException(e);
        }
    }

    public void run(IAction action) {
        try {
            DocbookFile source = this.getSourceFile();
            if (source == null) {
                return;
            }
            this.createXslFile().apply(source);
            this.reflesh();
            Activator.showMessageDialog("Output completed.");
        }
        catch (EDocbookRuntimeException e) {
            Activator.showErrorDialog(e);
        }
    }

    protected abstract DocbookXsl createXslFile();

    protected Properties createOutputProperties() {
        Properties prop = new Properties();
        prop.put("doctype-public", "-//W3C//DTD HTML 4.01 Transitional//EN");
        prop.put("doctype-system", "http://www.w3.org/TR/html4/loose.dtd");
        prop.put("method", "html");
        prop.put("indent", "yes");
        prop.put("encoding", "UTF-8");
        return prop;
    }

    protected Map<String, String> createParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("use.extensions", "1");
        return params;
    }
}

