/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EE2EWindows
extends Action {
    private static final String MARKER_ID = "jp.sourceforge.projects.ee2e.core.windows";
    private static final String POS_NUMBER = "posNumber";
    private static final String NOW_NUMBER = "nowNumber";
    private static final String ACTIVE_FLAG = "activeFlag";
    private static final String BOOKMARK_ID = "org.eclipse.ui.views.BookmarkNavigator";
    private int pos;

    public EE2EWindows(int pos) {
        this.pos = pos;
        this.setText(String.valueOf(EE2EPlugin.getResourceString("action.windows")) + "(&" + pos + ")");
    }

    public void run() {
        IMarker[] allMarker = this.getPosMarker();
        int oldPos = allMarker.length <= 0 ? 1 : allMarker[0].getAttribute(NOW_NUMBER, 0);
        if (oldPos == this.pos) {
            return;
        }
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IWorkbench bentch = plugin.getWorkbench();
        if (bentch == null) {
            return;
        }
        IWorkbenchPage activePage = bentch.getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart activePart = activePage.getActiveEditor();
        int i = 0;
        while (i < allMarker.length) {
            if (allMarker[i].getAttribute(POS_NUMBER, -1) == oldPos) {
                try {
                    allMarker[i].delete();
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        allMarker = this.getPosMarker();
        IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
        EE2EDebug.printf(5, "IWorkbenchWindow=" + bentch.getWorkbenchWindows().length);
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            EE2EDebug.printf(5, "IWorkbenchPage=" + window.getPages().length);
            if (page != null) {
                IEditorReference[] editorRefarence = page.getEditorReferences();
                int k = 0;
                while (k < editorRefarence.length) {
                    IEditorInput editorInput;
                    IEditorPart part = editorRefarence[k].getEditor(false);
                    if (part != null && (editorInput = part.getEditorInput()) != null && editorInput instanceof IFileEditorInput) {
                        IFile resource;
                        block31: {
                            resource = ((IFileEditorInput)editorInput).getFile();
                            IMarker marker = null;
                            try {
                                String oldMakerId = MARKER_ID;
                                marker = resource.createMarker(oldMakerId);
                                marker.setAttribute("severity", 0);
                                boolean activeFlag = activePart.equals(part);
                                marker.setAttribute("message", (Object)this.getMessage(oldPos, activeFlag));
                                marker.setAttribute("location", (Object)("No." + oldPos));
                                marker.setAttribute("priority", 0);
                                int lineNumber = this.getLineNumber(part);
                                marker.setAttribute("lineNumber", lineNumber + 1);
                                marker.setAttribute(POS_NUMBER, oldPos);
                                marker.setAttribute(NOW_NUMBER, this.pos);
                                if (activeFlag) {
                                    marker.setAttribute(ACTIVE_FLAG, true);
                                } else {
                                    marker.setAttribute(ACTIVE_FLAG, false);
                                }
                            }
                            catch (CoreException coreException) {
                                if (marker == null) break block31;
                                try {
                                    marker.delete();
                                }
                                catch (CoreException coreException2) {}
                            }
                        }
                        if (!this.isMarkerExists(allMarker, this.pos, (IResource)resource)) {
                            page.closeEditor(part, true);
                        }
                    }
                    ++k;
                }
            }
        }
        activePart = null;
        int i2 = 0;
        while (i2 < allMarker.length) {
            int localOldPos = allMarker[i2].getAttribute(POS_NUMBER, -1);
            if (localOldPos != this.pos) {
                boolean activeFlag = allMarker[i2].getAttribute(ACTIVE_FLAG, false);
                try {
                    allMarker[i2].setAttribute(NOW_NUMBER, this.pos);
                    allMarker[i2].setAttribute("message", (Object)this.getMessage(localOldPos, activeFlag));
                }
                catch (CoreException coreException) {}
            } else {
                IResource resource = allMarker[i2].getResource();
                if (resource instanceof IFile) {
                    try {
                        FileEditorInput input = new FileEditorInput((IFile)resource);
                        IEditorPart part = activePage.openEditor((IEditorInput)input, "org.eclipse.ui.systemInPlaceEditor");
                        int lineNumber = allMarker[i2].getAttribute("lineNumber", 0) - 1;
                        this.setLineNumber(part, lineNumber);
                        if (allMarker[i2].getAttribute(ACTIVE_FLAG, false)) {
                            activePart = part;
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
                try {
                    allMarker[i2].delete();
                }
                catch (CoreException coreException) {}
            }
            ++i2;
        }
        if (activePart != null) {
            activePage.activate((IWorkbenchPart)activePart);
        }
        this.openBookMark();
    }

    public String getMessage(int oldPos, boolean activeFlag) {
        String active = activeFlag ? "a" : "";
        return "(" + oldPos + "/" + this.pos + ")" + active + " EE2E " + EE2EPlugin.getResourceString("action.windows");
    }

    public int getLineNumber(IEditorPart editorPart) {
        if (!(editorPart instanceof AbstractTextEditor)) {
            return 0;
        }
        AbstractTextEditor editor = (AbstractTextEditor)editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return 0;
        }
        int offset = ((ITextSelection)selection).getOffset();
        try {
            return document.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public void setLineNumber(IEditorPart editorPart, int lineNumber) {
        if (!(editorPart instanceof AbstractTextEditor)) {
            return;
        }
        AbstractTextEditor editor = (AbstractTextEditor)editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            int start = document.getLineOffset(lineNumber);
            editor.selectAndReveal(start, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected boolean isMarkerExists(IMarker[] marker, int target, IResource resource) {
        int i = 0;
        while (i < marker.length) {
            if (marker[i].getAttribute(POS_NUMBER, -1) == target && marker[i].getResource().equals((Object)resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IMarker[] getPosMarker() {
        IMarker[] marker;
        IWorkspaceRoot root = EE2EPlugin.getWorkspace().getRoot();
        try {
            marker = root.findMarkers(MARKER_ID, true, 2);
        }
        catch (CoreException coreException) {
            return null;
        }
        return marker;
    }

    protected void deleteMarkerExists(IMarker[] marker) {
        int i = 0;
        while (i < marker.length) {
            try {
                marker[i].delete();
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    protected void openBookMark() {
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IWorkbench bentch = plugin.getWorkbench();
        if (bentch == null) {
            return;
        }
        IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            page.showView(BOOKMARK_ID);
        }
        catch (PartInitException e) {
            EE2EDebug.printf(1, e.getMessage());
        }
    }
}

