package jp.sourceforge.projects.ee2e.core;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import java.util.*;
import org.eclipse.jface.preference.*;

/**
 * The main plugin class to be used in the desktop.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static EE2EPlugin plugin = null;
	//Resource bundle.
	private ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "jp.sourceforge.projects.ee2e.core";
    public static final String MESSAGE_VIEW_ID = PLUGIN_ID + ".scratch.EE2EMessageView";
    public static final String MINI_BUFFER_VIEW_ID = PLUGIN_ID + ".display.EE2EMiniBufferView";
    public static final String INDENT_ID = PLUGIN_ID + ".editor.EE2EIndentAction";
    
	public static final String P_SET_FLAG = "setFlag";
	public static final String P_MENU = "preference.menu";
    public static final String P_DEBUG_LEVEL = "preference.debuglevel";
    //
    public static final String P_URL_JUMP_HOST = "preference.urljump.host";
    public static final String P_URL_JUMP_NUMBER = "preference.urljump.number";
    public static final String P_COMPACT_INDENT = "preference.compact";
    public static final String P_ENGLISH = "preference.english";
    //
    public static final String P_RUN_MAIN  = "run.main";
    public static final String P_RUN_MAIN_SNOOPER = "run.main.snooper";
    public static final String P_RUN_MAIN_COMBO = "run.main.combo";
    public static final String P_RUN_MAIN_PARENT = "run.main.parent";
    public static final String P_RUN_MAIN_EXE  = "run.main.exe";
    public static final String P_RUN_MAIN_CLASSPATH_BASE = "run.main.classbase";
    public static final String P_RUN_MAIN_ARGUMENT  = "run.main.argument";
    public static final String P_RUN_MAIN_FILE  = "run.main.file";
    public static final String P_RUN_MAIN_FOLDER  = "run.main.folder";
    public static final String P_RUN_MAIN_SAVE  = "run.main.save";
    public static final String P_RUN_MAIN_LOAD  = "run.main.load";
    public static final String P_RUN_MAIN_BASE  = "run.main.base";
    //
    public static final String P_RUN_DEST = "run.dest";
    //
    public static final String P_RUN_SOURCE = "run.source";
    //
    public static final String P_PROGRAM_BASE = "program_base.";
    //
    public static final String P_MESSAGE_DELETE = "message.delete";
    public static final String P_MESSAGE_DEBUG = "message.debug";
    public static final String P_MESSAGE_EDITOR = "message.editor";
    public static final String P_MESSAGE_SYSTEM = "message.system";
    public static final String P_MESSAGE_NUMBER = "message.number";
    //
    public static final String P_CONTRY = "contry";
    public static final String P_LOCALE = "language";
    public static final String P_CONTRY_LABEL = "contry.label";
    public static final String P_LOCALE_LABEL = "language.label";
    //
	/**
	 * The constructor.
	 */
	public EE2EPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
        
        try {
            IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
            if (store.getBoolean(P_ENGLISH)) {
                Locale defaultLocale = Locale.getDefault();
                Locale.setDefault(Locale.ENGLISH);
                this.resourceBundle = ResourceBundle.getBundle("ee2e",Locale.ENGLISH);
                Locale.setDefault(defaultLocale);
            } else {
                this.resourceBundle = ResourceBundle.getBundle("ee2e");
            }
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
    }

	/**
	 * Returns the shared instance.
	 */
	public static EE2EPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		if (EE2EPlugin.getDefault() == null) {
			return key;
		}
		ResourceBundle bundle = EE2EPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	/**
     * 
     */
    public void initializeDefaults() {
		IPreferenceStore store = this.getPreferenceStore();
		store.setDefault(EE2EPlugin.P_SET_FLAG, 1);
		//String folder;
        store.setDefault(EE2EPlugin.P_DEBUG_LEVEL, 0);
		store.setDefault(P_URL_JUMP_HOST,"localhost");
        store.setDefault(P_URL_JUMP_NUMBER,8080);
        store.setDefault(P_ENGLISH,false);
        store.setDefault(P_CONTRY,EE2EPlugin.getResourceString(P_CONTRY));
        store.setDefault(P_LOCALE,EE2EPlugin.getResourceString(P_LOCALE));
        store.setDefault(P_COMPACT_INDENT,EE2EPlugin.getResourceString(P_COMPACT_INDENT));
	}
}
