package jp.sourceforge.projects.ee2e.core.editors;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;

import org.eclipse.jface.text.Position;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public abstract class EE2EIndentBehavior implements EE2EMenuBehavior {
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.indent" + "&\t");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.indent.tooltip");
    }
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, IDocument, ITextSelection)
     */
    public final void doBehavior(
        AbstractTextEditor editor,
        IDocument document,
        ITextSelection textSelection)
        throws BadLocationException {

        int offset = textSelection.getOffset() + textSelection.getLength();

        Position saveExcursion = new Position(offset);
        document.addPosition(saveExcursion);

        this.doIndent(offset,document);

        offset = saveExcursion.getOffset();
        document.removePosition(saveExcursion);
        int head = EE2ELispBase.get().beginningOfLine(offset,document);
        head = EE2ELispBase.get().skipCharsForward(head," \t",document) + 1;
        if( head < document.getLength() ) {
            offset = head;
        }
        EE2ESelectIndent sec = new EE2ESelectIndent(offset);
        editor.getSelectionProvider().setSelection(sec);
        //
        // redhat linux motif-ver issue
        editor.setFocus();
    }
    protected abstract void doIndent(int offset,IDocument document) throws BadLocationException;

}
