package jp.sourceforge.projects.ee2e.core.editors;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EUnCommentRegion implements EE2EMenuBehavior {
	public EE2EUnCommentRegion() {
	}
    /**
    * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
    */
    public String getText() {
        return EE2EPlugin.getResourceString("action.uncommentR") + "(&<)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.uncommentR.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
	public void doBehavior(AbstractTextEditor editor,IDocument document,ITextSelection textSelection) throws BadLocationException {
		String text = textSelection.getText();
		if ((textSelection.getLength() <= 0) && (text.equals(""))) {
			return;
		}
		String oldText = "";
		while (true) {
			String str = "<!--";
			int ans = text.indexOf(str);
			if (ans < 0) {
				break;
			}
			oldText += text.substring(0,ans);
			text = text.substring(ans + str.length());
		}
		text = oldText + text;
		oldText = "";
		while (true) {
			String str = "-->";
			int ans = text.indexOf(str);
			if (ans < 0) {
				break;
			}
			oldText += text.substring(0,ans);
			text = text.substring(ans + str.length());
		}
		text = oldText + text;
		document.replace(
				textSelection.getOffset(),
				textSelection.getLength(),text);
	}
}