package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2REe2e</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="ee2e">
 *   <tag>
 *     <attribute name="indent" type="int"/>
 *     <attribute name="derivation" type="string"/>
 *   </tag>
 *   <sequence>
 *     <ref label="require" occurs="*"/>
 *     <ref label="structureList" occurs="*"/>
 *     <ref label="defvar" occurs="*"/>
 *     <ref label="iterationList" occurs="?"/>
 *     <ref label="processList" occurs="*"/>
 *     <ref label="templateList" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="ee2e"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="indent" type="int"/&gt;
 *     &lt;attribute name="derivation" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="require" occurs="*"/&gt;
 *     &lt;ref label="structureList" occurs="*"/&gt;
 *     &lt;ref label="defvar" occurs="*"/&gt;
 *     &lt;ref label="iterationList" occurs="?"/&gt;
 *     &lt;ref label="processList" occurs="*"/&gt;
 *     &lt;ref label="templateList" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:17 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2REe2e implements java.io.Serializable {
    private Integer indent_;
    private String derivation_;
    // List<EE2RRequire>
    private java.util.List require_ = new java.util.ArrayList();
    // List<EE2RStructureList>
    private java.util.List structureList_ = new java.util.ArrayList();
    // List<EE2RDefvar>
    private java.util.List defvar_ = new java.util.ArrayList();
    private EE2RIterationList iterationList_;
    // List<EE2RProcessList>
    private java.util.List processList_ = new java.util.ArrayList();
    // List<EE2RTemplateList>
    private java.util.List templateList_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2REe2e</code>.
     *
     */
    public EE2REe2e() {
    }

    /**
     * Creates a <code>EE2REe2e</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2REe2e(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2REe2e</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2REe2e(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2REe2e</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2REe2e(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2REe2e</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2REe2e(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2REe2e</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2REe2e(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2REe2e</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2REe2e(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2REe2e</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2REe2e(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2REe2e</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2REe2e(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2REe2e</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2REe2e(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        indent_ = URelaxer.getAttributePropertyAsIntObject(element, "indent");
        derivation_ = URelaxer.getAttributePropertyAsString(element, "derivation");
        require_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RRequire.isMatch(stack)) {
                addRequire(new EE2RRequire(stack));
            } else {
                break;
            }
        }
        structureList_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RStructureList.isMatch(stack)) {
                addStructureList(new EE2RStructureList(stack));
            } else {
                break;
            }
        }
        defvar_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RDefvar.isMatch(stack)) {
                addDefvar(new EE2RDefvar(stack));
            } else {
                break;
            }
        }
        if (EE2RIterationList.isMatch(stack)) {
            setIterationList(new EE2RIterationList(stack));
        }
        processList_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RProcessList.isMatch(stack)) {
                addProcessList(new EE2RProcessList(stack));
            } else {
                break;
            }
        }
        templateList_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RTemplateList.isMatch(stack)) {
                addTemplateList(new EE2RTemplateList(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("ee2e");
        int size;
        if (this.indent_ != null) {
            URelaxer.setAttributePropertyByInt(element, "indent", this.indent_);
        }
        if (this.derivation_ != null) {
            URelaxer.setAttributePropertyByString(element, "derivation", this.derivation_);
        }
        size = this.require_.size();
        for (int i = 0;i < size;i++) {
            EE2RRequire value = (EE2RRequire)this.require_.get(i);
            value.makeElement(element);
        }
        size = this.structureList_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructureList value = (EE2RStructureList)this.structureList_.get(i);
            value.makeElement(element);
        }
        size = this.defvar_.size();
        for (int i = 0;i < size;i++) {
            EE2RDefvar value = (EE2RDefvar)this.defvar_.get(i);
            value.makeElement(element);
        }
        if (this.iterationList_ != null) {
            this.iterationList_.makeElement(element);
        }
        size = this.processList_.size();
        for (int i = 0;i < size;i++) {
            EE2RProcessList value = (EE2RProcessList)this.processList_.get(i);
            value.makeElement(element);
        }
        size = this.templateList_.size();
        for (int i = 0;i < size;i++) {
            EE2RTemplateList value = (EE2RTemplateList)this.templateList_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2REe2e</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2REe2e</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the int property <b>indent</b>.
     *
     * @exception IllegalStateException
     * @return int
     */
    public int getIndent() throws IllegalStateException {
        if (indent_ == null) {
            throw (new IllegalStateException("indent_"));
        }
        return (indent_.intValue());
    }

    /**
     * Gets the int property <b>indent</b>.
     *
     * @exception IllegalStateException
     * @return Integer
     */
    public Integer getIndentAsInteger() throws IllegalStateException {
        return (indent_);
    }

    /**
     * Check the int property <b>indent</b>.
     *
     * @return boolean
     */
    public boolean checkIndent() {
        return (indent_ != null);
    }

    /**
     * Sets the int property <b>indent</b>.
     *
     * @param indent
     */
    public void setIndent(int indent) {
        this.indent_ = new Integer(indent);
    }

    /**
     * Sets the int property <b>indent</b>.
     *
     * @param indent
     */
    public void setIndent(Integer indent) {
        this.indent_ = indent;
    }

    /**
     * Gets the String property <b>derivation</b>.
     *
     * @return String
     */
    public final String getDerivation() {
        return (derivation_);
    }

    /**
     * Sets the String property <b>derivation</b>.
     *
     * @param derivation
     */
    public final void setDerivation(String derivation) {
        this.derivation_ = derivation;
    }

    /**
     * Gets the EE2RRequire property <b>require</b>.
     *
     * @return EE2RRequire[]
     */
    public final EE2RRequire[] getRequire() {
        EE2RRequire[] array = new EE2RRequire[require_.size()];
        return ((EE2RRequire[])require_.toArray(array));
    }

    /**
     * Sets the EE2RRequire property <b>require</b>.
     *
     * @param require
     */
    public final void setRequire(EE2RRequire[] require) {
        this.require_.clear();
        this.require_.addAll(java.util.Arrays.asList(require));
    }

    /**
     * Sets the EE2RRequire property <b>require</b>.
     *
     * @param require
     */
    public final void setRequire(EE2RRequire require) {
        this.require_.clear();
        this.require_.add(require);
    }

    /**
     * Adds the EE2RRequire property <b>require</b>.
     *
     * @param require
     */
    public final void addRequire(EE2RRequire require) {
        this.require_.add(require);
    }

    /**
     * Gets number of the EE2RRequire property <b>require</b>.
     *
     * @return int
     */
    public final int getRequireCount() {
        return (require_.size());
    }

    /**
     * Gets the EE2RRequire property <b>require</b> by index.
     *
     * @param index
     * @return EE2RRequire
     */
    public final EE2RRequire getRequire(int index) {
        return ((EE2RRequire)require_.get(index));
    }

    /**
     * Sets the EE2RRequire property <b>require</b> by index.
     *
     * @param index
     * @param require
     */
    public final void setRequire(int index, EE2RRequire require) {
        this.require_.set(index, require);
    }

    /**
     * Gets the EE2RStructureList property <b>structureList</b>.
     *
     * @return EE2RStructureList[]
     */
    public final EE2RStructureList[] getStructureList() {
        EE2RStructureList[] array = new EE2RStructureList[structureList_.size()];
        return ((EE2RStructureList[])structureList_.toArray(array));
    }

    /**
     * Sets the EE2RStructureList property <b>structureList</b>.
     *
     * @param structureList
     */
    public final void setStructureList(EE2RStructureList[] structureList) {
        this.structureList_.clear();
        this.structureList_.addAll(java.util.Arrays.asList(structureList));
    }

    /**
     * Sets the EE2RStructureList property <b>structureList</b>.
     *
     * @param structureList
     */
    public final void setStructureList(EE2RStructureList structureList) {
        this.structureList_.clear();
        this.structureList_.add(structureList);
    }

    /**
     * Adds the EE2RStructureList property <b>structureList</b>.
     *
     * @param structureList
     */
    public final void addStructureList(EE2RStructureList structureList) {
        this.structureList_.add(structureList);
    }

    /**
     * Gets number of the EE2RStructureList property <b>structureList</b>.
     *
     * @return int
     */
    public final int getStructureListCount() {
        return (structureList_.size());
    }

    /**
     * Gets the EE2RStructureList property <b>structureList</b> by index.
     *
     * @param index
     * @return EE2RStructureList
     */
    public final EE2RStructureList getStructureList(int index) {
        return ((EE2RStructureList)structureList_.get(index));
    }

    /**
     * Sets the EE2RStructureList property <b>structureList</b> by index.
     *
     * @param index
     * @param structureList
     */
    public final void setStructureList(int index, EE2RStructureList structureList) {
        this.structureList_.set(index, structureList);
    }

    /**
     * Gets the EE2RDefvar property <b>defvar</b>.
     *
     * @return EE2RDefvar[]
     */
    public final EE2RDefvar[] getDefvar() {
        EE2RDefvar[] array = new EE2RDefvar[defvar_.size()];
        return ((EE2RDefvar[])defvar_.toArray(array));
    }

    /**
     * Sets the EE2RDefvar property <b>defvar</b>.
     *
     * @param defvar
     */
    public final void setDefvar(EE2RDefvar[] defvar) {
        this.defvar_.clear();
        this.defvar_.addAll(java.util.Arrays.asList(defvar));
    }

    /**
     * Sets the EE2RDefvar property <b>defvar</b>.
     *
     * @param defvar
     */
    public final void setDefvar(EE2RDefvar defvar) {
        this.defvar_.clear();
        this.defvar_.add(defvar);
    }

    /**
     * Adds the EE2RDefvar property <b>defvar</b>.
     *
     * @param defvar
     */
    public final void addDefvar(EE2RDefvar defvar) {
        this.defvar_.add(defvar);
    }

    /**
     * Gets number of the EE2RDefvar property <b>defvar</b>.
     *
     * @return int
     */
    public final int getDefvarCount() {
        return (defvar_.size());
    }

    /**
     * Gets the EE2RDefvar property <b>defvar</b> by index.
     *
     * @param index
     * @return EE2RDefvar
     */
    public final EE2RDefvar getDefvar(int index) {
        return ((EE2RDefvar)defvar_.get(index));
    }

    /**
     * Sets the EE2RDefvar property <b>defvar</b> by index.
     *
     * @param index
     * @param defvar
     */
    public final void setDefvar(int index, EE2RDefvar defvar) {
        this.defvar_.set(index, defvar);
    }

    /**
     * Gets the EE2RIterationList property <b>iterationList</b>.
     *
     * @return EE2RIterationList
     */
    public final EE2RIterationList getIterationList() {
        return (iterationList_);
    }

    /**
     * Sets the EE2RIterationList property <b>iterationList</b>.
     *
     * @param iterationList
     */
    public final void setIterationList(EE2RIterationList iterationList) {
        this.iterationList_ = iterationList;
    }

    /**
     * Gets the EE2RProcessList property <b>processList</b>.
     *
     * @return EE2RProcessList[]
     */
    public final EE2RProcessList[] getProcessList() {
        EE2RProcessList[] array = new EE2RProcessList[processList_.size()];
        return ((EE2RProcessList[])processList_.toArray(array));
    }

    /**
     * Sets the EE2RProcessList property <b>processList</b>.
     *
     * @param processList
     */
    public final void setProcessList(EE2RProcessList[] processList) {
        this.processList_.clear();
        this.processList_.addAll(java.util.Arrays.asList(processList));
    }

    /**
     * Sets the EE2RProcessList property <b>processList</b>.
     *
     * @param processList
     */
    public final void setProcessList(EE2RProcessList processList) {
        this.processList_.clear();
        this.processList_.add(processList);
    }

    /**
     * Adds the EE2RProcessList property <b>processList</b>.
     *
     * @param processList
     */
    public final void addProcessList(EE2RProcessList processList) {
        this.processList_.add(processList);
    }

    /**
     * Gets number of the EE2RProcessList property <b>processList</b>.
     *
     * @return int
     */
    public final int getProcessListCount() {
        return (processList_.size());
    }

    /**
     * Gets the EE2RProcessList property <b>processList</b> by index.
     *
     * @param index
     * @return EE2RProcessList
     */
    public final EE2RProcessList getProcessList(int index) {
        return ((EE2RProcessList)processList_.get(index));
    }

    /**
     * Sets the EE2RProcessList property <b>processList</b> by index.
     *
     * @param index
     * @param processList
     */
    public final void setProcessList(int index, EE2RProcessList processList) {
        this.processList_.set(index, processList);
    }

    /**
     * Gets the EE2RTemplateList property <b>templateList</b>.
     *
     * @return EE2RTemplateList[]
     */
    public final EE2RTemplateList[] getTemplateList() {
        EE2RTemplateList[] array = new EE2RTemplateList[templateList_.size()];
        return ((EE2RTemplateList[])templateList_.toArray(array));
    }

    /**
     * Sets the EE2RTemplateList property <b>templateList</b>.
     *
     * @param templateList
     */
    public final void setTemplateList(EE2RTemplateList[] templateList) {
        this.templateList_.clear();
        this.templateList_.addAll(java.util.Arrays.asList(templateList));
    }

    /**
     * Sets the EE2RTemplateList property <b>templateList</b>.
     *
     * @param templateList
     */
    public final void setTemplateList(EE2RTemplateList templateList) {
        this.templateList_.clear();
        this.templateList_.add(templateList);
    }

    /**
     * Adds the EE2RTemplateList property <b>templateList</b>.
     *
     * @param templateList
     */
    public final void addTemplateList(EE2RTemplateList templateList) {
        this.templateList_.add(templateList);
    }

    /**
     * Gets number of the EE2RTemplateList property <b>templateList</b>.
     *
     * @return int
     */
    public final int getTemplateListCount() {
        return (templateList_.size());
    }

    /**
     * Gets the EE2RTemplateList property <b>templateList</b> by index.
     *
     * @param index
     * @return EE2RTemplateList
     */
    public final EE2RTemplateList getTemplateList(int index) {
        return ((EE2RTemplateList)templateList_.get(index));
    }

    /**
     * Sets the EE2RTemplateList property <b>templateList</b> by index.
     *
     * @param index
     * @param templateList
     */
    public final void setTemplateList(int index, EE2RTemplateList templateList) {
        this.templateList_.set(index, templateList);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<ee2e");
        if (indent_ != null) {
            buffer.append(" indent=\"");
            buffer.append(Integer.toString(getIndent()));
            buffer.append("\"");
        }
        if (derivation_ != null) {
            buffer.append(" derivation=\"");
            buffer.append(URelaxer.escapeAttrQuot(getDerivation()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.require_.size();
        for (int i = 0;i < size;i++) {
            EE2RRequire value = (EE2RRequire)this.require_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.structureList_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructureList value = (EE2RStructureList)this.structureList_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.defvar_.size();
        for (int i = 0;i < size;i++) {
            EE2RDefvar value = (EE2RDefvar)this.defvar_.get(i);
            value.makeTextElement(buffer);
        }
        if (iterationList_ != null) {
            iterationList_.makeTextElement(buffer);
        }
        size = this.processList_.size();
        for (int i = 0;i < size;i++) {
            EE2RProcessList value = (EE2RProcessList)this.processList_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.templateList_.size();
        for (int i = 0;i < size;i++) {
            EE2RTemplateList value = (EE2RTemplateList)this.templateList_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</ee2e>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<ee2e");
        if (indent_ != null) {
            buffer.print(" indent=\"");
            buffer.print(Integer.toString(getIndent()));
            buffer.print("\"");
        }
        if (derivation_ != null) {
            buffer.print(" derivation=\"");
            buffer.print(URelaxer.escapeAttrQuot(getDerivation()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.require_.size();
        for (int i = 0;i < size;i++) {
            EE2RRequire value = (EE2RRequire)this.require_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.structureList_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructureList value = (EE2RStructureList)this.structureList_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.defvar_.size();
        for (int i = 0;i < size;i++) {
            EE2RDefvar value = (EE2RDefvar)this.defvar_.get(i);
            value.makeTextElement(buffer);
        }
        if (iterationList_ != null) {
            iterationList_.makeTextElement(buffer);
        }
        size = this.processList_.size();
        for (int i = 0;i < size;i++) {
            EE2RProcessList value = (EE2RProcessList)this.processList_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.templateList_.size();
        for (int i = 0;i < size;i++) {
            EE2RTemplateList value = (EE2RTemplateList)this.templateList_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</ee2e>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2REe2e</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "ee2e")) {
            return (false);
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RRequire.isMatchHungry(target)) {
                break;
            }
        }
        while (!target.isEmptyElement()) {
            if (!EE2RStructureList.isMatchHungry(target)) {
                break;
            }
        }
        while (!target.isEmptyElement()) {
            if (!EE2RDefvar.isMatchHungry(target)) {
                break;
            }
        }
        if (EE2RIterationList.isMatchHungry(target)) {
        }
        while (!target.isEmptyElement()) {
            if (!EE2RProcessList.isMatchHungry(target)) {
                break;
            }
        }
        while (!target.isEmptyElement()) {
            if (!EE2RTemplateList.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2REe2e</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2REe2e</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
