/*
 * Created on 2004/08/28
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.core.indent;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Test Suite
 */
public class EE2EIndentAllTests {

    public static Test suite() {
        TestSuite suite = new TestSuite(
                "Test for jp.sourceforge.projects.ee2e.indent");
        //$JUnit-BEGIN$
        suite.addTestSuite(EE2ECppMiniFormatBehaviorTest.class);
        suite.addTest(new TestSuite(EE2ECppSharpTest.class));
        suite.addTest(new TestSuite(EE2ECppStringTest.class));
        suite.addTest(new TestSuite(EE2ELispBaseTest.class));
        //
        suite.addTest(new TestSuite(EE2EIndentXHtmlTest.class));
        //
        suite.addTest(new TestSuite(EE2EIndentJavaBasicTest.class));
        suite.addTest(new TestSuite(EE2EIndentJavaCommentTest.class));
        suite.addTest(new TestSuite(EE2EIndentJavaCircleTest.class));
        //
        suite.addTest(new TestSuite(EE2EIndentJavaBasicNextTest.class));
        suite.addTest(new TestSuite(EE2EIndentJavaCommentNextTest.class));
        suite.addTest(new TestSuite(EE2EIndentJavaCircleNextTest.class));
        suite.addTest(new TestSuite(EE2EIndentJavaMethodTest.class));
        //
        suite.addTest(new TestSuite(EE2EIndentSnmpTest.class));
        //
        suite.addTest(new TestSuite(EE2EIndentCppArrayTest.class));
        //$JUnit-END$
        return suite;
    }
    
    public static EE2EDocument createDocument(String string) {
        if (factory == null) {
            setEE2EDocumentFactory(new EE2EDocumentFactory());
        }
        return factory.createEE2EDocument(string);
    }
    public static void setEE2EDocumentFactory(EE2EDocumentFactory fac) {
        factory = fac;
    }
    private static EE2EDocumentFactory factory;
}

