package jp.sourceforge.projects.ee2e.core.indent;

/**
 * Test for XML indent.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentXHtmlTest extends EE2EIndentBaseTest {

	/**
	 * Constructor for EE2EIndentXHtmlTest.
	 * @param name
	 */
	public EE2EIndentXHtmlTest(String name) {
		super(name);
	}

	public void testDoIndentRealTop() {
		String base = "";
		String now = "foo bar boo\n";
		String answer = base + now;
		this.doIndent(base, "   " + now, answer);
	}

	public void testDoIndentTop() {
		String base = "   \n\t  \n";
		String now = "foo bar boo\n";
		String answer = base + now;
		this.doIndent(base, "   " + now, answer);
	}

	public void testDoIndentStartTag() {
		String base = "  <b>\n";
		String now = "foo bar boo\n";
		String answer = base + "    " + now;
		this.doIndent(base, now, answer);
	}
	public void testDoIndentBigTag() {
		String base = "<!DOCTYPE menubar SYSTEM \"menu.dtd\">\n"
            + "\n";
        String now = "<menubar hogehoge=\"aaa\"\n";
		String answer = base + now;
		now = "   " + now;
		this.doIndent(base,now, answer);
	}
	public void testDoIndentBigTagStillComplete() {
		String base = "<!DOCTYPE module\n"
            + "  SYSTEM \"relaxCore.dtd\">\n";
        String now = "<module relaxCoreVersion=\"1.0\">\n";
		String answer = base + now;
		this.doIndent(base, "   " + now, answer);
	}

	public void testDoIndentStartBeforeChar() {
		String base = "  aaa<li>\n";
		String now = "foo bar boo\n";
		String answer = base + "    " + now;
		now = " " + now;
		this.doIndent(base, now, answer);
	}
	public void testDoIndentStartTagAfterChar() {
		String base = "  <li>foo\n";
		String now = "foo bar boo\n";
		String answer = base + "    " + now;
		this.doIndent(base, "       " + now, answer);
	}
	public void testDoIndentStartTagBothChar() {
		String base = "  foo<li>bar\n";
		String now = "foo bar boo\n";
		String answer = base + "    " + now;
		this.doIndent(base, "       " + now, answer);
	}
	public void testDoIndentMainLine() {
		String base = "  bbb\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		this.doIndent(base, now, answer);
	}
	public void testDoIndentEndTag() {
		String base = "  </li>\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentEndTagBeforeChar() {
		String base = "    aaa</li>\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentEndTagAfterChar() {
		String base = "    </li>foo\n";
		String now = "foo bar boo\n";
		String answer = base + "    " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentEndTagBothChar() {
		String base = "    aaa</li>foo\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		now = "     " + now;
		this.doIndent(base, now , answer);
	}
	public void testDoIndentMultiOpen() {
		String base = "  <li><a>aaa</a>\n";
		String now = "foo bar boo\n";
		String answer = base + "    " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentMultiClose() {
		String base = "  <li><a>aaa</a></li>\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentSingleTag() {
		String base = "  <br />\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentMultiStartTag() {
		String base = "  <tr><td>\n";
		String now = "foo bar boo\n";
		String answer = base + "    " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentMultiEndTag() {
		String base = "  </tr></td>\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentStillTagA() {
		String base = "  <a class=\"box\"\n";
		String now = "href=\"aaa.txt\"\n";
		String answer = base + "    " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentStillTagB() {
		String base = "  <a class=\"box\"\n";
		String now = "href=\"aaa.txt\">\n";
		String answer = base + "    " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentStillTagMainLine() {
		String base = "  <a class=\"box\"\n" + "    href=\"aaa.txt\"\n";
		String now = "name=\"aaa\"\n";
		String answer = base + "    " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentStillTagEnd() {
		String base = "  <a class=\"box\"\n" + "  href=\"aaa.txt\">\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		now =  "     " + now;
		this.doIndent(base,now, answer);
	}
	public void testDoIndentStillStartTagEnd() {
		String base = "<module relaxCoreVersion=\"1.0\"\n"
            + "  xmlns:relaxer=\"http://www.relaxer.org/xmlns/relaxer\">\n"
            + "\n";
		String now = "<interface>\n";
		String answer = base + "  " + now;
		now = "     " + now;
		this.doIndent(base, now , answer);
	}
	public void testDoIndentStillSingleTagEnd() {
		String base = "  <br\n" + "    />\n";
		String now = "foo bar boo\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentTargetEndTag() {
		String base = "    aaa\n";
		String now = "</foo>\n";
		String answer = base + "  " + now;
		now = "     " + now;
		this.doIndent(base, now , answer);
	}
	public void testDoIndentTargetStartTag() {
		String base = "  aaa\n";
		String now = "<foo>\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentTargetSingleTag() {
		String base = "  aaa\n";
		String now = "<br />\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentTargetLi() {
		String base = "  aaa\n";
		String now = "<\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentTargetGt() {
		String base = "  aaa\n";
		String now = ">\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentTargetGtSingle() {
		String base = "  aaa\n";
		String now = "/>\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
	public void testDoIndentTargetSitllStartTag() {
		String base = "  aaa\n";
		String now = "bbb=\"ccc\">\n";
		String answer = base + "  " + now;
		this.doIndent(base, "     " + now, answer);
	}
    public void testDoIndentQuestion() {
		String base = "<doc:doc xmlns:doc=\"http://doc\">\n";
		String now = "<doc:p>  </doc:p>\n";
		String answer = base + "  " + now;
		now = "     " + now;
		this.doIndent(base, now, answer);
	}
	//
    public EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentXML(2, false);
    }
}

