/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.sourceforge.projects.ee2e.cindenter.CIExecutePanel;
import jp.sourceforge.projects.ee2e.cindenter.CIFolderPanel;
import jp.sourceforge.projects.ee2e.cindenter.CIIfdefPanel;
import jp.sourceforge.projects.ee2e.cindenter.CINextButtonActionListener;
import jp.sourceforge.projects.ee2e.cindenter.CINextPanel;
import jp.sourceforge.projects.ee2e.cindenter.CIPlugin;
import jp.sourceforge.projects.ee2e.cindenter.CIWindowClose;

class CIFrame
extends JFrame {
    public static final String CARD_HEAD = "CI";
    public static final String TITLE = "frame.top.title";
    public static final String BUTTON_NEXT = "button.next";
    public static final String BUTTON_END = "button.end";
    private int nowPanel;
    private JPanel mainPanel;
    private JButton nextButton;
    private CINextPanel[] nextPanel;

    public CIFrame() {
        super(CIPlugin.getDefault().getString(TITLE));
        this.addWindowListener(new CIWindowClose(this));
        this.createFrame();
    }

    public void createFrame() {
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.nextPanel = new CINextPanel[3];
        this.nextPanel[0] = new CIFolderPanel();
        this.nextPanel[1] = new CIIfdefPanel();
        this.nextPanel[2] = new CIExecutePanel();
        CardLayout cLayout = new CardLayout();
        this.mainPanel.setLayout(cLayout);
        int i = 0;
        while (i < this.nextPanel.length) {
            this.mainPanel.add((Component)this.nextPanel[i].createComponent(), CARD_HEAD + i);
            ++i;
        }
        this.nowPanel = 0;
        String titleKey = this.nextPanel[this.nowPanel].firstAction();
        titleKey = CIPlugin.getDefault().getString(titleKey);
        cLayout.show(this.mainPanel, CARD_HEAD + this.nowPanel);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.nextButton = new JButton(CIPlugin.getDefault().getString(BUTTON_NEXT));
        this.nextButton.addActionListener(new CINextButtonActionListener());
        this.getContentPane().add((Component)this.nextButton, "South");
    }

    public void doNextAction() {
        this.nextButton.setEnabled(false);
        if (this.nextPanel.length <= this.nowPanel) {
            return;
        }
        CINextPanel panel = this.nextPanel[this.nowPanel];
        panel.nextAction();
        if (!panel.isNextOk()) {
            return;
        }
        ++this.nowPanel;
        if (this.nextPanel.length <= this.nowPanel) {
            return;
        }
        panel = this.nextPanel[this.nowPanel];
        String titleKey = panel.firstAction();
        if (panel.isLast()) {
            this.nextButton.setText(CIPlugin.getDefault().getString(BUTTON_END));
        }
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, CARD_HEAD + this.nowPanel);
        this.nextButton.setEnabled(true);
    }
}

