/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2ELispBase;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2ESelectIndent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public abstract class EE2EIndentBehavior
implements EE2EMenuBehavior {
    public String getText() {
        return EE2EPlugin.getResourceString("action.indent");
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.indent.tooltip");
    }

    public final void doBehavior(AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        int offset = textSelection.getOffset() + textSelection.getLength();
        Position saveExcursion = new Position(offset);
        document.addPosition(saveExcursion);
        this.doIndent(offset, document);
        offset = saveExcursion.getOffset();
        document.removePosition(saveExcursion);
        int head = EE2ELispBase.get().beginningOfLine(offset, document);
        head = EE2ELispBase.get().skipCharsForward(head, " \t", document) + 1;
        if (head < document.getLength()) {
            offset = head;
        }
        EE2ESelectIndent sec = new EE2ESelectIndent(offset);
        editor.getSelectionProvider().setSelection((ISelection)sec);
        editor.setFocus();
    }

    protected abstract void doIndent(int var1, IDocument var2) throws BadLocationException;
}

