/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2ETranslateRegion
implements EE2EMenuBehavior {
    public static final String LEFT_BEFOR = "<";
    public static final String RIGHT_BEFOR = ">";
    public static final String DOUBLE_BEFOR = "\"";
    public static final String AMP_BEFOR = "&";
    public static final String LEFT_AFTER = "&lt;";
    public static final String RIGHT_AFTER = "&gt;";
    public static final String AMP_AFTER = "&amp;";
    public static final String DOUBLE_AFTER = "&quot;";

    public String getText() {
        return String.valueOf(EE2EPlugin.getResourceString("action.translateR")) + "(&:)";
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.translateR.tooltip");
    }

    public void doBehavior(AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        String text = textSelection.getText();
        if (textSelection.getLength() <= 0 && text.equals("")) {
            return;
        }
        String oldText = "";
        while (true) {
            int ltInt = text.indexOf(LEFT_BEFOR);
            int gtInt = text.indexOf(RIGHT_BEFOR);
            int ampInt = text.indexOf(AMP_BEFOR);
            int doubleInt = -1;
            if (this.isDouble()) {
                doubleInt = text.indexOf(DOUBLE_BEFOR);
            }
            if (ltInt < 0 && gtInt < 0 && ampInt < 0 && doubleInt < 0) break;
            if (ltInt < 0) {
                ltInt = Integer.MAX_VALUE;
            }
            if (gtInt < 0) {
                gtInt = Integer.MAX_VALUE;
            }
            if (ampInt < 0) {
                ampInt = Integer.MAX_VALUE;
            }
            if (doubleInt < 0) {
                doubleInt = Integer.MAX_VALUE;
            }
            String before = LEFT_BEFOR;
            String result = LEFT_AFTER;
            int min = ltInt;
            if (gtInt < min) {
                min = gtInt;
                before = RIGHT_BEFOR;
                result = RIGHT_AFTER;
            }
            if (ampInt < min) {
                min = ampInt;
                before = AMP_BEFOR;
                result = AMP_AFTER;
            }
            if (this.isDouble() && doubleInt < min) {
                min = doubleInt;
                before = DOUBLE_BEFOR;
                result = DOUBLE_AFTER;
            }
            oldText = String.valueOf(oldText) + text.substring(0, min);
            oldText = String.valueOf(oldText) + result;
            text = text.substring(min + before.length());
        }
        text = String.valueOf(oldText) + text;
        document.replace(textSelection.getOffset(), textSelection.getLength(), text);
    }

    public boolean isDouble() {
        return false;
    }
}

