/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.typeset;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2ELispBase;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import jp.sourceforge.projects.ee2e.core.typeset.EE2EReasonedFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2EFileJump
implements EE2EMenuBehavior {
    private static final String NG_CHARACTOR = "\t\r\n;\"'`\\<>[]{}()@&=";

    public String getText() {
        return String.valueOf(EE2EPlugin.getResourceString("action.filejump")) + "(&g)";
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.filejump.tooltip");
    }

    public final void doBehavior(AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            EE2EDebug.printf(1, "page not found");
        }
        try {
            IEditorInput editorInput = editor.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                throw new PartInitException("Invalid Input: Must be IFileEditorInput");
            }
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            this.doAction(textSelection, fileInput, document, page);
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)page.getWorkbenchWindow().getShell(), (String)WorkbenchMessages.getString((String)"OpenWithMenu.dialogTitle"), (String)e.getMessage(), (PartInitException)e);
        }
    }

    protected void doAction(ITextSelection textSelection, IFileEditorInput fileInput, IDocument document, IWorkbenchPage page) throws BadLocationException, PartInitException {
        String extention = textSelection.getText();
        if (extention == null || extention.equals("")) {
            int offset = textSelection.getOffset();
            int back = EE2ELispBase.get().findCharsBackward(offset, NG_CHARACTOR, document);
            int forward = EE2ELispBase.get().findCharsForward(offset, NG_CHARACTOR, document, document.getLength() - 1);
            if (document.getLength() <= forward) {
                forward = document.getLength() - 1;
            }
            if (back > 0 && back < forward) {
                ++back;
            }
            try {
                extention = document.get(back, forward - back);
            }
            catch (BadLocationException badLocationException) {
                throw new PartInitException("Bad location! offset=" + offset + " back=" + back + " forward=" + forward);
            }
            if (extention == null || extention.equals("")) {
                throw new PartInitException("Not region!");
            }
        }
        IFile iFile = fileInput.getFile();
        IContainer container = iFile.getParent();
        IPath path = container.getLocation();
        EE2EReasonedFile reasonedFile = new EE2EReasonedFile();
        IFile anserFile = reasonedFile.getFile(extention, path.toFile());
        this.openEditor(anserFile, page);
    }

    protected void openEditor(IFile anserFile, IWorkbenchPage page) throws PartInitException {
        EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descripter = registry.getDefaultEditor(anserFile.getName());
        FileEditorInput input = new FileEditorInput(anserFile);
        page.openEditor((IEditorInput)input, descripter.getId());
    }
}

