package jp.sourceforge.projects.ee2e.core.preferences;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class EE2EPreferencePage
    extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {

    public EE2EPreferencePage() {
        super(GRID);
        initializeStaticDefaults();
        this.setPreferenceStore(EE2EPlugin.getDefault().getPreferenceStore());
        this.setDescription(EE2EPlugin.getResourceString(EE2EPlugin.P_MENU));
        EE2EDebug.printf(3, "EE2EPreferencePage#EE2EPreferencePage()");
    }
    
	/**
     * Sets the default values of the preferences.
     */
    public void initializeDefaults() {
		initializeStaticDefaults();
    }
    /**
     * Method checkStaticDefaults.
     * @param part
     */
    public static final void checkStaticDefaults(IEditorPart part) {
        org.eclipse.jface.preference.IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
        if ((store.getInt(EE2EPlugin.P_SET_FLAG) == 0)
            || (store.getString(EE2EPlugin.P_CONTRY) == null)
            || store.getString(EE2EPlugin.P_CONTRY).equals("")
            || (store.getString(EE2EPlugin.P_LOCALE) == null)
            || store.getString(EE2EPlugin.P_LOCALE).equals("")) {
        	initializeStaticDefaults();
        }
    }
    public static final void initializeStaticDefaults() {
    	IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
		store.setDefault(EE2EPlugin.P_SET_FLAG, 1);
		//String folder;
        store.setDefault(EE2EPlugin.P_DEBUG_LEVEL, 0);
		store.setDefault(EE2EPlugin.P_URL_JUMP_HOST,"localhost");
        store.setDefault(EE2EPlugin.P_URL_JUMP_NUMBER,8080);
        store.setDefault(EE2EPlugin.P_CONTRY,EE2EPlugin.getResourceString(EE2EPlugin.P_CONTRY));
        store.setDefault(EE2EPlugin.P_LOCALE,EE2EPlugin.getResourceString(EE2EPlugin.P_LOCALE));
        store.setDefault(EE2EPlugin.P_COMPACT_INDENT,EE2EPlugin.getResourceString(EE2EPlugin.P_COMPACT_INDENT));
	}

    /**
        * Creates the field editors. Field editors are abstractions of
        * the common GUI blocks needed to manipulate various types
        * of preferences. Each field editor knows how to save and
        * restore itself.
        */
    public void createFieldEditors() {
        EE2EDebug.printf(3, "EE2EPreferencePage#createFieldEditors()");
        this.addField(
            new IntegerFieldEditor(
                EE2EPlugin.P_DEBUG_LEVEL,
                EE2EPlugin.getResourceString(EE2EPlugin.P_DEBUG_LEVEL),
                getFieldEditorParent()));
        this.addField(
            new StringFieldEditor(
                EE2EPlugin.P_URL_JUMP_HOST,
                EE2EPlugin.getResourceString(EE2EPlugin.P_URL_JUMP_HOST),
                getFieldEditorParent()));
        this.addField(
            new IntegerFieldEditor(
                EE2EPlugin.P_URL_JUMP_NUMBER,
                EE2EPlugin.getResourceString(EE2EPlugin.P_URL_JUMP_NUMBER),
                getFieldEditorParent()));
        this.addField(
            new StringFieldEditor(
                EE2EPlugin.P_CONTRY,
                EE2EPlugin.getResourceString(EE2EPlugin.P_CONTRY_LABEL),
                getFieldEditorParent()));
        this.addField(
            new StringFieldEditor(
                EE2EPlugin.P_LOCALE,
                EE2EPlugin.getResourceString(EE2EPlugin.P_LOCALE_LABEL),
                getFieldEditorParent()));
        this.addField(
            new BooleanFieldEditor(
                EE2EPlugin.P_COMPACT_INDENT,
                EE2EPlugin.getResourceString(EE2EPlugin.P_COMPACT_INDENT),
                getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        EE2EDebug.printf(3, "EE2EPreferencePage#init()");
    }
}