package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RProcessList</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="processList">
 *   <tag>
 *     <attribute name="processName" type="string"/>
 *     <attribute name="folder" type="string"/>
 *     <attribute name="file" type="string"/>
 *     <attribute name="fileType" type="string"/>
 *     <attribute name="isUnix" type="boolean"/>
 *     <attribute name="isJava" type="boolean"/>
 *   </tag>
 *   <sequence>
 *     <ref label="process" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="processList"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="processName" type="string"/&gt;
 *     &lt;attribute name="folder" type="string"/&gt;
 *     &lt;attribute name="file" type="string"/&gt;
 *     &lt;attribute name="fileType" type="string"/&gt;
 *     &lt;attribute name="isUnix" type="boolean"/&gt;
 *     &lt;attribute name="isJava" type="boolean"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="process" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RProcessList implements java.io.Serializable {
    private String processName_;
    private String folder_;
    private String file_;
    private String fileType_;
    private Boolean isUnix_;
    private Boolean isJava_;
    // List<EE2RProcess>
    private java.util.List process_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2RProcessList</code>.
     *
     */
    public EE2RProcessList() {
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RProcessList(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RProcessList(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RProcessList(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RProcessList(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RProcessList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RProcessList(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RProcessList(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RProcessList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RProcessList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RProcessList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RProcessList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        processName_ = URelaxer.getAttributePropertyAsString(element, "processName");
        folder_ = URelaxer.getAttributePropertyAsString(element, "folder");
        file_ = URelaxer.getAttributePropertyAsString(element, "file");
        fileType_ = URelaxer.getAttributePropertyAsString(element, "fileType");
        isUnix_ = URelaxer.getAttributePropertyAsBooleanObject(element, "isUnix");
        isJava_ = URelaxer.getAttributePropertyAsBooleanObject(element, "isJava");
        process_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RProcess.isMatch(stack)) {
                addProcess(new EE2RProcess(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("processList");
        int size;
        if (this.processName_ != null) {
            URelaxer.setAttributePropertyByString(element, "processName", this.processName_);
        }
        if (this.folder_ != null) {
            URelaxer.setAttributePropertyByString(element, "folder", this.folder_);
        }
        if (this.file_ != null) {
            URelaxer.setAttributePropertyByString(element, "file", this.file_);
        }
        if (this.fileType_ != null) {
            URelaxer.setAttributePropertyByString(element, "fileType", this.fileType_);
        }
        if (this.isUnix_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "isUnix", this.isUnix_);
        }
        if (this.isJava_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "isJava", this.isJava_);
        }
        size = this.process_.size();
        for (int i = 0;i < size;i++) {
            EE2RProcess value = (EE2RProcess)this.process_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RProcessList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RProcessList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>processName</b>.
     *
     * @return String
     */
    public final String getProcessName() {
        return (processName_);
    }

    /**
     * Sets the String property <b>processName</b>.
     *
     * @param processName
     */
    public final void setProcessName(String processName) {
        this.processName_ = processName;
    }

    /**
     * Gets the String property <b>folder</b>.
     *
     * @return String
     */
    public final String getFolder() {
        return (folder_);
    }

    /**
     * Sets the String property <b>folder</b>.
     *
     * @param folder
     */
    public final void setFolder(String folder) {
        this.folder_ = folder;
    }

    /**
     * Gets the String property <b>file</b>.
     *
     * @return String
     */
    public final String getFile() {
        return (file_);
    }

    /**
     * Sets the String property <b>file</b>.
     *
     * @param file
     */
    public final void setFile(String file) {
        this.file_ = file;
    }

    /**
     * Gets the String property <b>fileType</b>.
     *
     * @return String
     */
    public final String getFileType() {
        return (fileType_);
    }

    /**
     * Sets the String property <b>fileType</b>.
     *
     * @param fileType
     */
    public final void setFileType(String fileType) {
        this.fileType_ = fileType;
    }

    /**
     * Gets the boolean property <b>isUnix</b>.
     *
     * @exception IllegalStateException
     * @return boolean
     */
    public boolean getIsUnix() throws IllegalStateException {
        if (isUnix_ == null) {
            throw (new IllegalStateException("isUnix_"));
        }
        return (isUnix_.booleanValue());
    }

    /**
     * Gets the boolean property <b>isUnix</b>.
     *
     * @exception IllegalStateException
     * @return Boolean
     */
    public Boolean getIsUnixAsBoolean() throws IllegalStateException {
        return (isUnix_);
    }

    /**
     * Check the boolean property <b>isUnix</b>.
     *
     * @return boolean
     */
    public boolean checkIsUnix() {
        return (isUnix_ != null);
    }

    /**
     * Sets the boolean property <b>isUnix</b>.
     *
     * @param isUnix
     */
    public void setIsUnix(boolean isUnix) {
        this.isUnix_ = new Boolean(isUnix);
    }

    /**
     * Sets the boolean property <b>isUnix</b>.
     *
     * @param isUnix
     */
    public void setIsUnix(Boolean isUnix) {
        this.isUnix_ = isUnix;
    }

    /**
     * Gets the boolean property <b>isJava</b>.
     *
     * @exception IllegalStateException
     * @return boolean
     */
    public boolean getIsJava() throws IllegalStateException {
        if (isJava_ == null) {
            throw (new IllegalStateException("isJava_"));
        }
        return (isJava_.booleanValue());
    }

    /**
     * Gets the boolean property <b>isJava</b>.
     *
     * @exception IllegalStateException
     * @return Boolean
     */
    public Boolean getIsJavaAsBoolean() throws IllegalStateException {
        return (isJava_);
    }

    /**
     * Check the boolean property <b>isJava</b>.
     *
     * @return boolean
     */
    public boolean checkIsJava() {
        return (isJava_ != null);
    }

    /**
     * Sets the boolean property <b>isJava</b>.
     *
     * @param isJava
     */
    public void setIsJava(boolean isJava) {
        this.isJava_ = new Boolean(isJava);
    }

    /**
     * Sets the boolean property <b>isJava</b>.
     *
     * @param isJava
     */
    public void setIsJava(Boolean isJava) {
        this.isJava_ = isJava;
    }

    /**
     * Gets the EE2RProcess property <b>process</b>.
     *
     * @return EE2RProcess[]
     */
    public final EE2RProcess[] getProcess() {
        EE2RProcess[] array = new EE2RProcess[process_.size()];
        return ((EE2RProcess[])process_.toArray(array));
    }

    /**
     * Sets the EE2RProcess property <b>process</b>.
     *
     * @param process
     */
    public final void setProcess(EE2RProcess[] process) {
        this.process_.clear();
        this.process_.addAll(java.util.Arrays.asList(process));
    }

    /**
     * Sets the EE2RProcess property <b>process</b>.
     *
     * @param process
     */
    public final void setProcess(EE2RProcess process) {
        this.process_.clear();
        this.process_.add(process);
    }

    /**
     * Adds the EE2RProcess property <b>process</b>.
     *
     * @param process
     */
    public final void addProcess(EE2RProcess process) {
        this.process_.add(process);
    }

    /**
     * Gets number of the EE2RProcess property <b>process</b>.
     *
     * @return int
     */
    public final int getProcessCount() {
        return (process_.size());
    }

    /**
     * Gets the EE2RProcess property <b>process</b> by index.
     *
     * @param index
     * @return EE2RProcess
     */
    public final EE2RProcess getProcess(int index) {
        return ((EE2RProcess)process_.get(index));
    }

    /**
     * Sets the EE2RProcess property <b>process</b> by index.
     *
     * @param index
     * @param process
     */
    public final void setProcess(int index, EE2RProcess process) {
        this.process_.set(index, process);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<processList");
        if (processName_ != null) {
            buffer.append(" processName=\"");
            buffer.append(URelaxer.escapeAttrQuot(getProcessName()));
            buffer.append("\"");
        }
        if (folder_ != null) {
            buffer.append(" folder=\"");
            buffer.append(URelaxer.escapeAttrQuot(getFolder()));
            buffer.append("\"");
        }
        if (file_ != null) {
            buffer.append(" file=\"");
            buffer.append(URelaxer.escapeAttrQuot(getFile()));
            buffer.append("\"");
        }
        if (fileType_ != null) {
            buffer.append(" fileType=\"");
            buffer.append(URelaxer.escapeAttrQuot(getFileType()));
            buffer.append("\"");
        }
        if (isUnix_ != null) {
            buffer.append(" isUnix=\"");
            buffer.append(new Boolean(getIsUnix()).toString());
            buffer.append("\"");
        }
        if (isJava_ != null) {
            buffer.append(" isJava=\"");
            buffer.append(new Boolean(getIsJava()).toString());
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.process_.size();
        for (int i = 0;i < size;i++) {
            EE2RProcess value = (EE2RProcess)this.process_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</processList>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<processList");
        if (processName_ != null) {
            buffer.print(" processName=\"");
            buffer.print(URelaxer.escapeAttrQuot(getProcessName()));
            buffer.print("\"");
        }
        if (folder_ != null) {
            buffer.print(" folder=\"");
            buffer.print(URelaxer.escapeAttrQuot(getFolder()));
            buffer.print("\"");
        }
        if (file_ != null) {
            buffer.print(" file=\"");
            buffer.print(URelaxer.escapeAttrQuot(getFile()));
            buffer.print("\"");
        }
        if (fileType_ != null) {
            buffer.print(" fileType=\"");
            buffer.print(URelaxer.escapeAttrQuot(getFileType()));
            buffer.print("\"");
        }
        if (isUnix_ != null) {
            buffer.print(" isUnix=\"");
            buffer.print(new Boolean(getIsUnix()).toString());
            buffer.print("\"");
        }
        if (isJava_ != null) {
            buffer.print(" isJava=\"");
            buffer.print(new Boolean(getIsJava()).toString());
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.process_.size();
        for (int i = 0;i < size;i++) {
            EE2RProcess value = (EE2RProcess)this.process_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</processList>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RProcessList</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "processList")) {
            return (false);
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RProcess.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RProcessList</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RProcessList</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
