package jp.sourceforge.projects.ee2e.core.typeset;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.*;
import org.eclipse.ui.*;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EDerivationResourceSystem extends EE2EDerivationResource {
    public EE2EDerivationResourceSystem(String derivationResource) {
    	super(derivationResource);
    }

	/**
	 * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
	 */
	public String getText() {
		return EE2EPlugin.getResourceString("action.typeset.derivation.system") + "(&e)";
	}

	/**
	 * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
	 */
	public String getToolTipText() {
		return EE2EPlugin.getResourceString("action.typeset.derivation.system.tooltip");
	}
	/**
	 * @see jp.sourceforge.projects.ee2e.core.typeset.EE2EFileJump#openEditor(IFile, IWorkbenchPage)
	 */
	protected void openEditor(IFile anserFile,IWorkbenchPage page) throws PartInitException {
        IEditorInput input = new FileEditorInput(anserFile);
        page.openEditor(input,IEditorRegistry.SYSTEM_EXTERNAL_EDITOR_ID);
	}
}