package jp.sourceforge.projects.ee2e.core.typeset;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.resources.IContainer;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
//
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.WorkbenchMessages;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2ELispBase;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import org.eclipse.ui.part.*;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EFileJump implements EE2EMenuBehavior {
    public EE2EFileJump() {
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.filejump") + "(&g)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.filejump.tooltip");
    }

    public final void doBehavior(
        AbstractTextEditor editor,
        IDocument document,
        ITextSelection textSelection)
        throws BadLocationException {
        //
        IWorkbenchPage page =
            PlatformUI
                .getWorkbench()
                .getActiveWorkbenchWindow()
                .getActivePage();
        if (page == null) {
            EE2EDebug.printf(1, "page not found");
        }
        try {
            IEditorInput editorInput = editor.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                throw new PartInitException("Invalid Input: Must be IFileEditorInput");
            }
            IFileEditorInput fileInput = (IFileEditorInput) editorInput;
            this.doAction(textSelection, fileInput, document, page);
        } catch (PartInitException e) {
            DialogUtil.openError(
                page.getWorkbenchWindow().getShell(),
                WorkbenchMessages.getString("OpenWithMenu.dialogTitle"),
                e.getMessage(),
                e);
        }
    }

    private static final String NG_CHARACTOR = "\t\r\n;\"\'`\\<>[]{}()@&=";
    /**
     * Method doAction.
     * @param textSelection
     * @param fileInput
     * @param page
     * @throws BadLocationException
     */
    protected void doAction(
        ITextSelection textSelection,
        IFileEditorInput fileInput,
        IDocument document,
        IWorkbenchPage page)
        throws BadLocationException, PartInitException {
        String extention = textSelection.getText();
        //
        if ((extention == null) || (extention.equals(""))) {
            int offset = textSelection.getOffset();
            int back =
                EE2ELispBase.get().findCharsBackward(
                    offset,
                    NG_CHARACTOR,
                    document);
            int forward =
                EE2ELispBase.get().findCharsForward(
                    offset,
                    NG_CHARACTOR,
                    document,
                    document.getLength() - 1);
            if (document.getLength() <= forward) {
                forward = document.getLength() - 1;
            }
            if ((0 < back) && (back < forward)) {
                back++;
            }
            try {
                extention = document.get(back, forward - back);
            } catch (BadLocationException e) {
                throw new PartInitException(
                    "Bad location! offset="
                        + offset
                        + " back="
                        + back
                        + " forward="
                        + forward);
            }
            if ((extention == null) || (extention.equals(""))) {
                throw new PartInitException("Not region!");
            }
        }
        IFile iFile = fileInput.getFile();
        IContainer container = iFile.getParent();
        IPath path = container.getLocation();
        EE2EReasonedFile reasonedFile = new EE2EReasonedFile();
        IFile anserFile = reasonedFile.getFile(extention, path.toFile());
        this.openEditor(anserFile, page);
    }
    protected void openEditor(IFile anserFile, IWorkbenchPage page)
        throws PartInitException {
        EditorRegistry registry =
            (EditorRegistry) PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descripter = registry.getDefaultEditor(anserFile.getName());
        IEditorInput input = new FileEditorInput(anserFile);
        page.openEditor(input, descripter.getId());
    }
}