/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.scratch;

import java.io.File;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.scratch.EE2EScratchView;
import jp.sourceforge.projects.ee2e.core.typeset.EE2EReasonedFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class EE2EConsoleAction
implements IViewActionDelegate {
    private IViewPart viewPart;
    private EE2EReasonedFile reasonedFile = new EE2EReasonedFile();

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        try {
            if (!(this.viewPart instanceof EE2EScratchView)) {
                throw new PartInitException(String.valueOf(this.viewPart.toString()) + " not understand!");
            }
            this.runScratch((EE2EScratchView)this.viewPart);
        }
        catch (PartInitException e) {
            EE2EPlugin plugin = EE2EPlugin.getDefault();
            if (plugin == null) {
                EE2EDebug.printf(1, "EE2EPlugin not found!");
                return;
            }
            IWorkbench bentch = plugin.getWorkbench();
            if (bentch == null) {
                EE2EDebug.printf(1, "IWorkbench not found!");
                return;
            }
            IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
            if (window == null) {
                EE2EDebug.printf(1, "IWorkbenchWindow not found!");
                return;
            }
            DialogUtil.openError((Shell)window.getShell(), (String)WorkbenchMessages.getString((String)"OpenWithMenu.dialogTitle"), (String)e.getMessage(), (PartInitException)e);
        }
    }

    protected void runScratch(EE2EScratchView scratchView) throws PartInitException {
        String selected = scratchView.getSelectionText();
        if (selected == null || selected.equals("")) {
            throw new PartInitException("Region not found!");
        }
        File parent = scratchView.getParent();
        this.actionStart(selected, parent);
    }

    protected abstract void actionStart(String var1, File var2) throws PartInitException;

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void openEditor(IFile anserFile, boolean flag) throws PartInitException {
        if (anserFile == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        FileEditorInput input = new FileEditorInput(anserFile);
        if (!flag) {
            page.openEditor((IEditorInput)input, "org.eclipse.ui.systemExternalEditor");
            return;
        }
        IEditorPart editorPart = page.openEditor((IEditorInput)input, "org.eclipse.ui.systemInPlaceEditor");
        this.gotoLine(editorPart);
    }

    public void gotoLine(IEditorPart editorPart) throws PartInitException {
        if (this.reasonedFile.getLineNumber() <= 0) {
            EE2EDebug.printf(1, "not number");
            return;
        }
        if (!(editorPart instanceof AbstractTextEditor)) {
            EE2EDebug.printf(1, "not AbstractTextEditor!!");
            return;
        }
        AbstractTextEditor editor = (AbstractTextEditor)editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            int lineNumber = this.reasonedFile.getLineNumber();
            int start = document.getLineOffset(lineNumber - 1);
            editor.selectAndReveal(start, 0);
            IWorkbenchWindow window = EE2EPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            page.activate((IWorkbenchPart)editor);
        }
        catch (BadLocationException e) {
            throw new PartInitException("BadLocationException e=" + e.getMessage());
        }
    }

    protected EE2EReasonedFile getReasonedFile() {
        return this.reasonedFile;
    }
}

