package jp.sourceforge.projects.ee2e.core.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code GeneCration.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ETabDestroyer implements EE2EMenuBehavior {
	public EE2ETabDestroyer() {
	}
    /**
    * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
    */
    public String getText() {
        return EE2EPlugin.getResourceString("action.tab");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.tab.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
	public void doBehavior(AbstractTextEditor editor,IDocument document,ITextSelection textSelection) throws BadLocationException {
        StringBuffer str = new StringBuffer(document.get());
        boolean flag = false;
        while (true) {
            int returnOffset = str.indexOf("\t");
            if (returnOffset < 0) {
                break;
            }
            str.replace(returnOffset, returnOffset + 1, "    ");
            flag = true;
        }
        if (flag) {
            document.set(str.toString());
        }
	}
}
