package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RStructureList</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="structureList">
 *   <tag>
 *     <attribute name="tagref" type="string"/>
 *     <attribute name="default" type="string"/>
 *     <attribute name="type" type="NMTOKEN">
 *       <enumeration value="section"/>
 *       <enumeration value="begin"/>
 *       <enumeration value="learge"/>
 *       <enumeration value="big"/>
 *       <enumeration value="return"/>
 *       <enumeration value="function"/>
 *     </attribute>
 *     <attribute name="argsep0" type="string"/>
 *     <attribute name="argsep1" type="string"/>
 *     <attribute name="argsep2" type="string"/>
 *     <attribute name="argsep3" type="string"/>
 *     <attribute name="argsep4" type="string"/>
 *     <attribute name="argsep5" type="string"/>
 *     <attribute name="mustmatch" type="boolean"/>
 *   </tag>
 *   <sequence>
 *     <ref label="tagext" occurs="*"/>
 *     <ref label="structure" occurs="+"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="structureList"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="tagref" type="string"/&gt;
 *     &lt;attribute name="default" type="string"/&gt;
 *     &lt;attribute name="type" type="NMTOKEN"&gt;
 *       &lt;enumeration value="section"/&gt;
 *       &lt;enumeration value="begin"/&gt;
 *       &lt;enumeration value="learge"/&gt;
 *       &lt;enumeration value="big"/&gt;
 *       &lt;enumeration value="return"/&gt;
 *       &lt;enumeration value="function"/&gt;
 *     &lt;/attribute&gt;
 *     &lt;attribute name="argsep0" type="string"/&gt;
 *     &lt;attribute name="argsep1" type="string"/&gt;
 *     &lt;attribute name="argsep2" type="string"/&gt;
 *     &lt;attribute name="argsep3" type="string"/&gt;
 *     &lt;attribute name="argsep4" type="string"/&gt;
 *     &lt;attribute name="argsep5" type="string"/&gt;
 *     &lt;attribute name="mustmatch" type="boolean"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="tagext" occurs="*"/&gt;
 *     &lt;ref label="structure" occurs="+"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RStructureList implements java.io.Serializable {
    private String tagref_;
    private String default_;
    private String type_;
    private String argsep0_;
    private String argsep1_;
    private String argsep2_;
    private String argsep3_;
    private String argsep4_;
    private String argsep5_;
    private Boolean mustmatch_;
    // List<EE2RTagext>
    private java.util.List tagext_ = new java.util.ArrayList();
    // List<EE2RStructure>
    private java.util.List structure_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2RStructureList</code>.
     *
     */
    public EE2RStructureList() {
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RStructureList(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RStructureList(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RStructureList(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructureList(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RStructureList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructureList(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructureList(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructureList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructureList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RStructureList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructureList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        tagref_ = URelaxer.getAttributePropertyAsString(element, "tagref");
        default_ = URelaxer.getAttributePropertyAsString(element, "default");
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        argsep0_ = URelaxer.getAttributePropertyAsString(element, "argsep0");
        argsep1_ = URelaxer.getAttributePropertyAsString(element, "argsep1");
        argsep2_ = URelaxer.getAttributePropertyAsString(element, "argsep2");
        argsep3_ = URelaxer.getAttributePropertyAsString(element, "argsep3");
        argsep4_ = URelaxer.getAttributePropertyAsString(element, "argsep4");
        argsep5_ = URelaxer.getAttributePropertyAsString(element, "argsep5");
        mustmatch_ = URelaxer.getAttributePropertyAsBooleanObject(element, "mustmatch");
        tagext_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RTagext.isMatch(stack)) {
                addTagext(new EE2RTagext(stack));
            } else {
                break;
            }
        }
        structure_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RStructure.isMatch(stack)) {
                addStructure(new EE2RStructure(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("structureList");
        int size;
        if (this.tagref_ != null) {
            URelaxer.setAttributePropertyByString(element, "tagref", this.tagref_);
        }
        if (this.default_ != null) {
            URelaxer.setAttributePropertyByString(element, "default", this.default_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.argsep0_ != null) {
            URelaxer.setAttributePropertyByString(element, "argsep0", this.argsep0_);
        }
        if (this.argsep1_ != null) {
            URelaxer.setAttributePropertyByString(element, "argsep1", this.argsep1_);
        }
        if (this.argsep2_ != null) {
            URelaxer.setAttributePropertyByString(element, "argsep2", this.argsep2_);
        }
        if (this.argsep3_ != null) {
            URelaxer.setAttributePropertyByString(element, "argsep3", this.argsep3_);
        }
        if (this.argsep4_ != null) {
            URelaxer.setAttributePropertyByString(element, "argsep4", this.argsep4_);
        }
        if (this.argsep5_ != null) {
            URelaxer.setAttributePropertyByString(element, "argsep5", this.argsep5_);
        }
        if (this.mustmatch_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "mustmatch", this.mustmatch_);
        }
        size = this.tagext_.size();
        for (int i = 0;i < size;i++) {
            EE2RTagext value = (EE2RTagext)this.tagext_.get(i);
            value.makeElement(element);
        }
        size = this.structure_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RStructureList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RStructureList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>tagref</b>.
     *
     * @return String
     */
    public final String getTagref() {
        return (tagref_);
    }

    /**
     * Sets the String property <b>tagref</b>.
     *
     * @param tagref
     */
    public final void setTagref(String tagref) {
        this.tagref_ = tagref;
    }

    /**
     * Gets the String property <b>default</b>.
     *
     * @return String
     */
    public final String getDefault() {
        return (default_);
    }

    /**
     * Sets the String property <b>default</b>.
     *
     * @param defaultValue
     */
    public final void setDefault(String defaultValue) {
        this.default_ = defaultValue;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the String property <b>argsep0</b>.
     *
     * @return String
     */
    public final String getArgsep0() {
        return (argsep0_);
    }

    /**
     * Sets the String property <b>argsep0</b>.
     *
     * @param argsep0
     */
    public final void setArgsep0(String argsep0) {
        this.argsep0_ = argsep0;
    }

    /**
     * Gets the String property <b>argsep1</b>.
     *
     * @return String
     */
    public final String getArgsep1() {
        return (argsep1_);
    }

    /**
     * Sets the String property <b>argsep1</b>.
     *
     * @param argsep1
     */
    public final void setArgsep1(String argsep1) {
        this.argsep1_ = argsep1;
    }

    /**
     * Gets the String property <b>argsep2</b>.
     *
     * @return String
     */
    public final String getArgsep2() {
        return (argsep2_);
    }

    /**
     * Sets the String property <b>argsep2</b>.
     *
     * @param argsep2
     */
    public final void setArgsep2(String argsep2) {
        this.argsep2_ = argsep2;
    }

    /**
     * Gets the String property <b>argsep3</b>.
     *
     * @return String
     */
    public final String getArgsep3() {
        return (argsep3_);
    }

    /**
     * Sets the String property <b>argsep3</b>.
     *
     * @param argsep3
     */
    public final void setArgsep3(String argsep3) {
        this.argsep3_ = argsep3;
    }

    /**
     * Gets the String property <b>argsep4</b>.
     *
     * @return String
     */
    public final String getArgsep4() {
        return (argsep4_);
    }

    /**
     * Sets the String property <b>argsep4</b>.
     *
     * @param argsep4
     */
    public final void setArgsep4(String argsep4) {
        this.argsep4_ = argsep4;
    }

    /**
     * Gets the String property <b>argsep5</b>.
     *
     * @return String
     */
    public final String getArgsep5() {
        return (argsep5_);
    }

    /**
     * Sets the String property <b>argsep5</b>.
     *
     * @param argsep5
     */
    public final void setArgsep5(String argsep5) {
        this.argsep5_ = argsep5;
    }

    /**
     * Gets the boolean property <b>mustmatch</b>.
     *
     * @exception IllegalStateException
     * @return boolean
     */
    public boolean getMustmatch() throws IllegalStateException {
        if (mustmatch_ == null) {
            throw (new IllegalStateException("mustmatch_"));
        }
        return (mustmatch_.booleanValue());
    }

    /**
     * Gets the boolean property <b>mustmatch</b>.
     *
     * @exception IllegalStateException
     * @return Boolean
     */
    public Boolean getMustmatchAsBoolean() throws IllegalStateException {
        return (mustmatch_);
    }

    /**
     * Check the boolean property <b>mustmatch</b>.
     *
     * @return boolean
     */
    public boolean checkMustmatch() {
        return (mustmatch_ != null);
    }

    /**
     * Sets the boolean property <b>mustmatch</b>.
     *
     * @param mustmatch
     */
    public void setMustmatch(boolean mustmatch) {
        this.mustmatch_ = new Boolean(mustmatch);
    }

    /**
     * Sets the boolean property <b>mustmatch</b>.
     *
     * @param mustmatch
     */
    public void setMustmatch(Boolean mustmatch) {
        this.mustmatch_ = mustmatch;
    }

    /**
     * Gets the EE2RTagext property <b>tagext</b>.
     *
     * @return EE2RTagext[]
     */
    public final EE2RTagext[] getTagext() {
        EE2RTagext[] array = new EE2RTagext[tagext_.size()];
        return ((EE2RTagext[])tagext_.toArray(array));
    }

    /**
     * Sets the EE2RTagext property <b>tagext</b>.
     *
     * @param tagext
     */
    public final void setTagext(EE2RTagext[] tagext) {
        this.tagext_.clear();
        this.tagext_.addAll(java.util.Arrays.asList(tagext));
    }

    /**
     * Sets the EE2RTagext property <b>tagext</b>.
     *
     * @param tagext
     */
    public final void setTagext(EE2RTagext tagext) {
        this.tagext_.clear();
        this.tagext_.add(tagext);
    }

    /**
     * Adds the EE2RTagext property <b>tagext</b>.
     *
     * @param tagext
     */
    public final void addTagext(EE2RTagext tagext) {
        this.tagext_.add(tagext);
    }

    /**
     * Gets number of the EE2RTagext property <b>tagext</b>.
     *
     * @return int
     */
    public final int getTagextCount() {
        return (tagext_.size());
    }

    /**
     * Gets the EE2RTagext property <b>tagext</b> by index.
     *
     * @param index
     * @return EE2RTagext
     */
    public final EE2RTagext getTagext(int index) {
        return ((EE2RTagext)tagext_.get(index));
    }

    /**
     * Sets the EE2RTagext property <b>tagext</b> by index.
     *
     * @param index
     * @param tagext
     */
    public final void setTagext(int index, EE2RTagext tagext) {
        this.tagext_.set(index, tagext);
    }

    /**
     * Gets the EE2RStructure property <b>structure</b>.
     *
     * @return EE2RStructure[]
     */
    public final EE2RStructure[] getStructure() {
        EE2RStructure[] array = new EE2RStructure[structure_.size()];
        return ((EE2RStructure[])structure_.toArray(array));
    }

    /**
     * Sets the EE2RStructure property <b>structure</b>.
     *
     * @param structure
     */
    public final void setStructure(EE2RStructure[] structure) {
        this.structure_.clear();
        this.structure_.addAll(java.util.Arrays.asList(structure));
    }

    /**
     * Sets the EE2RStructure property <b>structure</b>.
     *
     * @param structure
     */
    public final void setStructure(EE2RStructure structure) {
        this.structure_.clear();
        this.structure_.add(structure);
    }

    /**
     * Adds the EE2RStructure property <b>structure</b>.
     *
     * @param structure
     */
    public final void addStructure(EE2RStructure structure) {
        this.structure_.add(structure);
    }

    /**
     * Gets number of the EE2RStructure property <b>structure</b>.
     *
     * @return int
     */
    public final int getStructureCount() {
        return (structure_.size());
    }

    /**
     * Gets the EE2RStructure property <b>structure</b> by index.
     *
     * @param index
     * @return EE2RStructure
     */
    public final EE2RStructure getStructure(int index) {
        return ((EE2RStructure)structure_.get(index));
    }

    /**
     * Sets the EE2RStructure property <b>structure</b> by index.
     *
     * @param index
     * @param structure
     */
    public final void setStructure(int index, EE2RStructure structure) {
        this.structure_.set(index, structure);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<structureList");
        if (tagref_ != null) {
            buffer.append(" tagref=\"");
            buffer.append(URelaxer.escapeAttrQuot(getTagref()));
            buffer.append("\"");
        }
        if (default_ != null) {
            buffer.append(" default=\"");
            buffer.append(URelaxer.escapeAttrQuot(getDefault()));
            buffer.append("\"");
        }
        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(getType()));
            buffer.append("\"");
        }
        if (argsep0_ != null) {
            buffer.append(" argsep0=\"");
            buffer.append(URelaxer.escapeAttrQuot(getArgsep0()));
            buffer.append("\"");
        }
        if (argsep1_ != null) {
            buffer.append(" argsep1=\"");
            buffer.append(URelaxer.escapeAttrQuot(getArgsep1()));
            buffer.append("\"");
        }
        if (argsep2_ != null) {
            buffer.append(" argsep2=\"");
            buffer.append(URelaxer.escapeAttrQuot(getArgsep2()));
            buffer.append("\"");
        }
        if (argsep3_ != null) {
            buffer.append(" argsep3=\"");
            buffer.append(URelaxer.escapeAttrQuot(getArgsep3()));
            buffer.append("\"");
        }
        if (argsep4_ != null) {
            buffer.append(" argsep4=\"");
            buffer.append(URelaxer.escapeAttrQuot(getArgsep4()));
            buffer.append("\"");
        }
        if (argsep5_ != null) {
            buffer.append(" argsep5=\"");
            buffer.append(URelaxer.escapeAttrQuot(getArgsep5()));
            buffer.append("\"");
        }
        if (mustmatch_ != null) {
            buffer.append(" mustmatch=\"");
            buffer.append(new Boolean(getMustmatch()).toString());
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.tagext_.size();
        for (int i = 0;i < size;i++) {
            EE2RTagext value = (EE2RTagext)this.tagext_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.structure_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</structureList>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<structureList");
        if (tagref_ != null) {
            buffer.print(" tagref=\"");
            buffer.print(URelaxer.escapeAttrQuot(getTagref()));
            buffer.print("\"");
        }
        if (default_ != null) {
            buffer.print(" default=\"");
            buffer.print(URelaxer.escapeAttrQuot(getDefault()));
            buffer.print("\"");
        }
        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(getType()));
            buffer.print("\"");
        }
        if (argsep0_ != null) {
            buffer.print(" argsep0=\"");
            buffer.print(URelaxer.escapeAttrQuot(getArgsep0()));
            buffer.print("\"");
        }
        if (argsep1_ != null) {
            buffer.print(" argsep1=\"");
            buffer.print(URelaxer.escapeAttrQuot(getArgsep1()));
            buffer.print("\"");
        }
        if (argsep2_ != null) {
            buffer.print(" argsep2=\"");
            buffer.print(URelaxer.escapeAttrQuot(getArgsep2()));
            buffer.print("\"");
        }
        if (argsep3_ != null) {
            buffer.print(" argsep3=\"");
            buffer.print(URelaxer.escapeAttrQuot(getArgsep3()));
            buffer.print("\"");
        }
        if (argsep4_ != null) {
            buffer.print(" argsep4=\"");
            buffer.print(URelaxer.escapeAttrQuot(getArgsep4()));
            buffer.print("\"");
        }
        if (argsep5_ != null) {
            buffer.print(" argsep5=\"");
            buffer.print(URelaxer.escapeAttrQuot(getArgsep5()));
            buffer.print("\"");
        }
        if (mustmatch_ != null) {
            buffer.print(" mustmatch=\"");
            buffer.print(new Boolean(getMustmatch()).toString());
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.tagext_.size();
        for (int i = 0;i < size;i++) {
            EE2RTagext value = (EE2RTagext)this.tagext_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.structure_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</structureList>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RStructureList</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "structureList")) {
            return (false);
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RTagext.isMatchHungry(target)) {
                break;
            }
        }
        if (!EE2RStructure.isMatchHungry(target)) {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (!EE2RStructure.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RStructureList</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RStructureList</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
