package jp.sourceforge.projects.ee2e.core.cdt;
import jp.sourceforge.projects.ee2e.core.indent.EE2EDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentAction;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;
import jp.sourceforge.projects.ee2e.core.indent.EE2ELispBase;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentMake implements EE2EIndentAction {
    /** constractor */
    public EE2EIndentMake() {
    }

    public static final int INDENT_LEN = 4;

    /**
    * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, IDocument, ITextSelection)
    */
    public void doIndent(int offset, EE2EDocument document)
        throws EE2EIndentException {
        offset = EE2ELispBase.get().beginningOfLine(offset, document);
        int len = EE2ELispBase.get().indentLen(offset, document);
        len += INDENT_LEN;
        this.indentTo(offset, len, document);
    }
    protected void indentTo(int offset, int size, EE2EDocument document)
        throws EE2EIndentException {
        if (size < 0) {
            size = 0;
        }
        int realSize = 0;
        int len = 0;
        boolean tabNotUsedFlag = true;
        int begin = EE2ELispBase.get().beginningOfLine(offset, document);
        for (int i = begin; i < document.getLength(); i++) {
            if (document.getChar(i) == ' ') {
                realSize++;
                len++;
            } else if (document.getChar(i) == '\t') {
                realSize++;
                len += 4;
                tabNotUsedFlag = false;
            } else {
                break;
            }
        }
        if ((size == len) && tabNotUsedFlag) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < size; i += 4) {
            buff.append('\t');
        }
        document.replace(offset, realSize, buff.toString());
    }
}
