/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.display.EE2EMiniBufferView;
import jp.sourceforge.projects.ee2e.core.editors.EE2ECreateIMenuManager;
import jp.sourceforge.projects.ee2e.core.preferences.EE2EPreferencePage;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.osgi.framework.Bundle;

public class EE2ETextEditorActionContributor
extends BasicTextEditorActionContributor {
    protected static final String TEXT_EDITOR_SCOPE = "org.eclipse.ui.textEditorScope";
    protected static final String JAVA_EDITOR_SCOPE = "org.eclipse.jdt.ui.javaEditorScope";
    protected static final String CDT_EDITOR_SCOPE = "org.eclipse.cdt.ui.cEditorScope";
    protected static final String EE2E_CDT_FLAGMENT_ID = "jp.sourceforge.projects.ee2e.cdt.core";
    private static IMenuManager manager;
    private static EE2ECreateIMenuManager cManager;

    public EE2ETextEditorActionContributor() {
        EE2EDebug.printf(3, "EE2ETextEditorActionContributor start!");
    }

    public void setActiveEditor(IEditorPart part) {
        EE2EPreferencePage.checkStaticDefaults(part);
        EE2ETextEditorActionContributor.createIMenuManager(part);
        super.setActiveEditor(part);
    }

    public void dispose() {
        EE2EDebug.printf(3, "EE2ETextEditorActionContributor#dispose");
        EE2EMiniBufferView.removeEE2EDisplayCompletion();
        super.dispose();
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        EE2ETextEditorActionContributor.staticContributeToMenu(iMenuManager);
    }

    public static final synchronized void createIMenuManager(IEditorPart part) {
        EE2EDebug.printf(3, "EE2ETextEditorActionContributor#createIMenuManager");
        if (EE2ETextEditorActionContributor.getCManager() == null) {
            EE2ETextEditorActionContributor.setCManager(new EE2ECreateIMenuManager());
            EE2ETextEditorActionContributor.getCManager().overWriteManager(manager);
        }
        EE2ETextEditorActionContributor.getCManager().setActivePart((AbstractTextEditor)part);
    }

    public static final void staticContributeToMenu(IMenuManager myManager) {
        EE2EDebug.printf(3, "EE2ETextEditorActionContributor#contributeToMenu");
        manager = myManager;
        if (EE2ETextEditorActionContributor.getCManager() == null) {
            EE2ETextEditorActionContributor.setCManager(new EE2ECreateIMenuManager());
        }
        EE2ETextEditorActionContributor.getCManager().overWriteManager(manager);
    }

    public static boolean isEe2eCdt() {
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        if (plugin == null) {
            return false;
        }
        Bundle bundle = plugin.getBundle();
        Bundle[] fragments = InternalPlatform.getDefault().getFragments(bundle);
        int i = 0;
        while (i < fragments.length) {
            String id = fragments[i].getSymbolicName();
            EE2EDebug.printf(5, "isEe2eCdt i=" + i + " id=" + id);
            if (id.equals(EE2E_CDT_FLAGMENT_ID)) {
                return true;
            }
            ++i;
        }
        EE2EDebug.printf(3, "isEe2eCdt / not found");
        return false;
    }

    public static final EE2ECreateIMenuManager getCManager() {
        return cManager;
    }

    public static final void setCManager(EE2ECreateIMenuManager myManager) {
        cManager = myManager;
    }
}

