package jp.sourceforge.projects.ee2e.core.dedit;

import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

/**
 * @see http://graze.at.infoseek.co.jp/plugin/
 */
public class DFileDocumentProvider extends FileDocumentProvider {
    /**
     * 
     */
    public DFileDocumentProvider() {
        super();
    }
    private static String ascii2native(String srcStr){
        StringBuffer dstStrBuf = new StringBuffer();
        for(int i = 0; i < srcStr.length(); i++){
            if(srcStr.charAt(i) != '\\'){
                dstStrBuf.append(srcStr.charAt(i));
                continue;
            }
            i++;
            if(i >= srcStr.length()){
                break;
            }
            if(srcStr.charAt(i) != 'u'){
                dstStrBuf.append('\\').append(srcStr.charAt(i));
                continue;
            }
            i++;
            String escStr = srcStr.substring(i, i+4);
            dstStrBuf.append((char)Integer.parseInt(escStr, 16));
            i += 3;//
            
            
        }
        return dstStrBuf.toString();
    }
    /* (non-Javadoc)
     * @see org.eclipse.ui.editors.text.StorageDocumentProvider#setDocumentContent(org.eclipse.jface.text.IDocument, org.eclipse.ui.IEditorInput, java.lang.String)
     */
    protected boolean setDocumentContent(
        IDocument document,
        IEditorInput editorInput,
        String encoding)
        throws CoreException {
        //      System.out.println(encoding);
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput) editorInput).getFile();
            Document doc = new Document();
            super.setDocumentContent(
                doc,
                file.getContents(false),
                encoding);
            String srcStr = doc.get();
            String dstStr = ascii2native(srcStr);
            document.set(dstStr);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.texteditor.AbstractDocumentProvider#doSaveDocument(org.eclipse.core.runtime.IProgressMonitor, java.lang.Object, org.eclipse.jface.text.IDocument, boolean)
     */
    protected void doSaveDocument(
        IProgressMonitor monitor,
        Object element,
        IDocument document,
        boolean overwrite)
        throws CoreException {
        String srcStr = document.get();
        StringBuffer dstStrBuf = new StringBuffer();
        for (int i = 0; i < srcStr.length(); i++) {
            char ch = srcStr.charAt(i);
            if (ch <= 0x7F) {
                dstStrBuf.append(ch);
                continue;
            }
            String escStr = "0000" + Integer.toHexString(ch & 0xFFFF);
            dstStrBuf.append("\\u").append(escStr.substring(escStr.length() - 4));
        }
        Document doc = new Document();
        doc.set(dstStrBuf.toString());
        super.doSaveDocument(monitor, element, doc, overwrite);
    }
}