package jp.sourceforge.projects.ee2e.core.editors;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECommentRegion implements EE2EMenuBehavior {
    public EE2ECommentRegion() {
        /*EMPTY*/
    }

    /**
    * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
    */
    public String getText() {
        return EE2EPlugin.getResourceString("action.commentR") + "(&>)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.commentR.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
    public void doBehavior(
        AbstractTextEditor editor,
        ITextSelection textSelection)
        throws BadLocationException {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        String text = textSelection.getText();
        if ((textSelection.getLength() <= 0) && (text.equals(""))) {
            return;
        }
        java.io.StringReader sReader = new java.io.StringReader(text);
        java.io.BufferedReader bReader = new java.io.BufferedReader(sReader);
        java.io.StringWriter sWriter = new java.io.StringWriter();
        try {
            while (true) {
                String line = bReader.readLine();
                if (line == null) {
                    break;
                }
                sWriter.write("<!--");
                sWriter.write(line);
                sWriter.write("-->");
                sWriter.write("\n");
            }
            bReader.close();
            sWriter.close();
            document.replace(
                textSelection.getOffset(),
                textSelection.getLength(),
                sWriter.toString());
        } catch (java.io.IOException e) {
            EE2EDebug.printf(10, "IOException e=" + e.getMessage());
        }
    }
}
