package jp.sourceforge.projects.ee2e.core.indent;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentJsp implements EE2EIndentAction {
    /** constractor */
    public EE2EIndentJsp(EE2EIndentXML xml,boolean isRedundantCircleFlag) {
        this.javaIndent = new EE2EIndentJava(4,isRedundantCircleFlag);
        this.xmlIndent = xml;
    }
    private EE2EIndentJava javaIndent;
    private EE2EIndentXML xmlIndent;

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, EE2EDocument, ITextSelection)
     */
    public void doIndent(int offset, EE2EDocument document)
        throws EE2EIndentException {
        //
        int nextOffset = EE2ELispBase.get().beginningOfLine(offset, document);
        boolean isJavaIndent = false;
        while (0 < nextOffset) {
            nextOffset = EE2ELispBase.get().findCharsBackward(nextOffset, "<>", document);
            if (nextOffset <= 0) {
                break;
            }
            char ch = document.getChar(nextOffset);
            if ('<' == ch) {
                char nextCh = document.getChar(nextOffset + 1);
                if (('?' == nextCh) || ('%' == nextCh)) {
                    isJavaIndent = true;
                    break;
                }
            } else if ('>' == ch) {
                char nextCh = document.getChar(nextOffset - 1);
                if (('?' == nextCh) || ('%' == nextCh)) {
                    isJavaIndent = false;
                    break;
                }
            } else {
                isJavaIndent = false;
            }
            nextOffset--;
        }
        if (isJavaIndent) {
            this.javaIndent.doIndent(offset, document);
        } else {
            this.xmlIndent.doIndent(offset, document);
        }
    }
}
