package jp.sourceforge.projects.ee2e.ee.core.views;

import jp.sourceforge.projects.ee2e.ee.core.behavior.*;

import java.io.File;
import java.net.MalformedURLException;

import jp.sourceforge.projects.ee2e.ee.core.preferences.*;

import jp.sourceforge.projects.ee2e.ee.core.EEPlugin;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.part.*;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.*;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.*;
import org.eclipse.swt.SWT;


/**
 * This sample class demonstrates how to plug-in a new
 * workbench view. The view shows data obtained from the
 * model. The sample creates a dummy model on the fly,
 * but a real implementation would connect to the model
 * available either in this or another plug-in (e.g. the workspace).
 * The view is connected to the model using a content provider.
 * <p>
 * The view uses a label provider to define how model
 * objects should be presented in the view. Each
 * view can present the same model objects using
 * different labels and icons, if needed. Alternatively,
 * a single label provider can be shared between views
 * in order to ensure that objects of the same type are
 * presented in the same way everywhere.
 * <p>
 */

public class EE2EEtagsEditionView extends ViewPart implements EEGuiInterface {
    public static final int MAX_ACTION = 3;
    public static final String [] IMAGE_ARRAY = {
        "reload.gif",
        "up.gif",
        "down.gif"
    };

	/**
	 * The constructor.
	 */
	public EE2EEtagsEditionView() {
        this.behavior = new EEBehavior(this);
	}
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.makeColumnsEqualWidth = true;
        parent.setLayout(layout);

        this.text = new Text(parent, SWT.SINGLE | SWT.H_SCROLL);
        this.text.addKeyListener(this.keyListener);
        GridData grid1 = new GridData();
        grid1.horizontalAlignment = GridData.FILL;
        grid1.verticalAlignment = GridData.FILL;
        grid1.horizontalIndent = 1;
        grid1.horizontalSpan = layout.numColumns;
        grid1.verticalSpan = 1;
        grid1.grabExcessHorizontalSpace = true;
        grid1.grabExcessVerticalSpace = false;
        this.text.setLayoutData(grid1);
        
        //
        this.list = new org.eclipse.swt.widgets.List(parent, SWT.MULTI
                | SWT.V_SCROLL | SWT.H_SCROLL);
        this.list.addSelectionListener(this.selectionListener);
        GridData grid2 = new GridData();
        grid2.horizontalAlignment = GridData.FILL;
        grid2.verticalAlignment = GridData.FILL;
        grid2.horizontalIndent = 1;
        grid2.horizontalSpan = layout.numColumns;
        grid2.verticalSpan = 1;
        grid2.grabExcessHorizontalSpace = false;
        grid2.grabExcessVerticalSpace = true;
        this.list.setLayoutData(grid2);
        //
        makeActions(parent);
	}
	private void makeActions(Composite parent) {
        this.action = new Action[MAX_ACTION];
        for(int i = 0 ; i < MAX_ACTION ; i++) {
            action[i] = new EEAction(i) {
                public void run() {
                    EE2EEtagsEditionView.this.doAction(getIndex());
                }
            };
            String work = EEPlugin.getResourceString("ee.action" + i + ".name");
            action[i].setText(work);
            action[i].setToolTipText(work);
            action[i].setImageDescriptor(this.getImageDescriptor(IMAGE_ARRAY[i]));
            getViewSite().getActionBars().getToolBarManager().add(action[i]);
            getViewSite().getActionBars().getMenuManager().add(action[i]);
        }
	}
    public ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor image;
        try {
            java.net.URL prefix = EEPlugin.getDefault().getBundle().getEntry("icons/");
            image = ImageDescriptor.createFromURL(
                new java.net.URL(prefix, string));
        } catch (MalformedURLException e) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJS_INFO_TSK);
        }
        return image;
    }
    
    private SelectionListener selectionListener = new SelectionListener() {
        /**
         * Sent when selection occurs in the control.
         * <p>
         * For example, on some platforms selection occurs in a List when the
         * user selects an item or items.
         * </p>
         * 
         * @param e
         *            an event containing information about the selection
         */
        public void widgetSelected(SelectionEvent e) {
            EE2EEtagsEditionView.this.doSelect();
        }

        /**
         * Sent when default selection occurs in the control.
         * <p>
         * For example, on some platforms default selection occurs in a List
         * when the user double-clicks an item or types return in a Text.
         * </p>
         * 
         * @param e
         *            an event containing information about the default
         *            selection
         */
        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    private KeyListener keyListener = new KeyListener() {
        /**
         * Sent when a key is pressed on the system keyboard.
         * 
         * @param e
         *            an event containing information about the key press
         */
        public void keyPressed(KeyEvent e) {
        }

        /**
         * Sent when a key is released on the system keyboard.
         * 
         * @param e
         *            an event containing information about the key release
         */
        public void keyReleased(KeyEvent e) {
            if (e.character == ' ') {
                String text = EE2EEtagsEditionView.this.text.getText();
                text = text.substring(0,text.length() - 1);
                EE2EEtagsEditionView.this.text.setText("");
                EE2EEtagsEditionView.this.text.insert(text);
                EE2EEtagsEditionView.this.behavior.createSelectedList();
            } else if ((e.character == '\r') || (e.character == '\n')) {
                EE2EEtagsEditionView.this.doReturn();
            }
        }
    };
    

    private void showMessage(String message) {
        MessageDialog.openInformation(
            this.text.getShell(),
            "Etags View",
            message);
    }
    /**
     * Do menuvar action
     * 
     * @param index
     *            Button index
     */
    private void doAction(int index) {
       switch (index) {
        case 0: // Invoke reload
            String errorMessage = this.behavior.invokeReload();
            if (errorMessage != null) {
                this.showMessage(errorMessage);
            }
            break;
        case 1: // Invoke back
            this.doBackRtrunAction();
            break;
        default: // Invoke next
            this.doNextRtrunAction();
            break;
        }
    }
    protected void doReturn() {
        int index = this.list.getSelectionIndex();
        if (index < 0) {
            index = 0;
        }
        this.list.deselectAll();
        this.list.select(index);
        this.doSelect();
    }
    protected void doBackRtrunAction() {
        int index = this.list.getSelectionIndex();
        index--;
        if (index < 0) {
            index = eEtagsLine.length - 1;
        }
        this.list.deselectAll();
        this.list.select(index);
        this.doSelect();
    }
    protected void doNextRtrunAction() {
        int index = this.list.getSelectionIndex();
        index++;
        if (eEtagsLine.length <= index) {
            index = 0;
        }
        this.list.deselectAll();
        this.list.select(index);
        this.doSelect();
    }
    protected void doSelect() {
        int index = this.list.getSelectionIndex();
        if (this.eEtagsLine.length <= 0) {
            this.showMessage("list not found!");
            return;
        }
        EEtagsLine file = this.eEtagsLine[index];
        if (file == null) {
            this.showMessage("file not found!");
            return;
        }
        this.openFile(file.getFile(), file.getLine());
    }
    public String getTargetString() {
        return this.text.getText();
    }
    public void setTargetString(String targetString) {
        this.text.setText("");
        this.text.insert(targetString);
    }

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
        if (this.list != null) {
            this.list.setFocus();
        }
	}
    public String getEncode() {
        EEPreferencePage.checkStaticDefaults();
        IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        return store.getString(EEPreferencePage.P_ENCODE);
    }
    public String getTagsName() {
        EEPreferencePage.checkStaticDefaults();
        IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        return store.getString(EEPreferencePage.P_TAGS_FILE);
    }
    public void setListData(EEtagsLine [] eEtagsLine) {
        this.eEtagsLine = eEtagsLine;
        this.list.removeAll();
        for (int i = 0 ; i < this.eEtagsLine.length ; i++) {
            this.list.add(this.eEtagsLine[i].getListMessage());
        }
    }
    public void openFile(String file,int line) {
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        File fullPath = new java.io.File(this.getTagsName());
        fullPath = new File(fullPath,file);
        IPath appendPath = new Path(fullPath.toString());
        IFile anserFile = iWorkspaceRoot.getFileForLocation(appendPath);
        if (anserFile == null) {
            fullPath = new java.io.File(file);
            IPath singleAppendPath = new Path(fullPath.toString());
            anserFile = iWorkspaceRoot.getFileForLocation(singleAppendPath);
            if (anserFile == null) {
                this.showMessage(
                    "file not found. file=" + appendPath.toString());
                return;
            }
        }
        IEditorInput input = new FileEditorInput(anserFile);
        IEditorPart editorPart;
        IWorkbenchPage page =
            PlatformUI
                .getWorkbench()
                .getActiveWorkbenchWindow()
                .getActivePage();
        try {
            EditorRegistry registry =
                (EditorRegistry) PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descripter = registry.getDefaultEditor(anserFile.getName());
            editorPart = page.openEditor(input, descripter.getId());
        } catch (PartInitException e1) {
            this.showMessage(
                "PartInitException e=" + e1.getMessage());
            return;
        }
        if (line <= 0) {
            return;
        }
        if (!(editorPart instanceof AbstractTextEditor)) {
            return;
        }
        AbstractTextEditor editor = (AbstractTextEditor) editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument(editor.getEditorInput());
        try {
            int start = document.getLineOffset(line - 1);
            editor.selectAndReveal(start, 0);
            page.activate(editor);
        } catch (BadLocationException e) {
            this.showMessage(
                "BadLocationException e=" + e.getMessage());
        }
    }
    public String getDocumentFile() {
        AbstractTextEditor abstractTextEditor = this.getAbstractTextEditor();
        if (abstractTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = abstractTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile iFile =
            ((IFileEditorInput) editorInput).getFile();
        return iFile.getLocation().toFile().getAbsoluteFile().toString();
    }
    public String getDocumentBuffer() {
        AbstractTextEditor abstractTextEditor = this.getAbstractTextEditor();
        if (abstractTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = abstractTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IDocumentProvider documentProvider = abstractTextEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument(editorInput);
        return document.get();
    }
    protected AbstractTextEditor getAbstractTextEditor() {
        IWorkbenchPage page =
            PlatformUI
                .getWorkbench()
                .getActiveWorkbenchWindow()
                .getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        if (!(editorPart instanceof AbstractTextEditor)) {
            return null;
        }
        return (AbstractTextEditor) editorPart;
    }
    private EEtagsLine [] eEtagsLine;
    private Text text;
    private List list;
    private Action [] action;
    private EEBehavior behavior;
}
