/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.provider;

import elazyrest.core.servlet.RestServlet;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesLoader {
    private static PropertiesLoader _instance = new PropertiesLoader();
    private static Log log = LogFactory.getLog(PropertiesLoader.class);
    protected Map<String, Properties> instances = new HashMap<String, Properties>();

    public static Properties get(String key) {
        return _instance.getInstance(key);
    }

    public static boolean contains(String key) {
        return PropertiesLoader._instance.instances.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(String key, Properties instance) {
        Map<String, Properties> map = PropertiesLoader._instance.instances;
        synchronized (map) {
            PropertiesLoader._instance.instances.put(key, instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getInstance(String key) {
        Properties prop = null;
        Map<String, Properties> map = this.instances;
        synchronized (map) {
            if (this.instances.containsKey(key)) {
                prop = this.instances.get(key);
            } else {
                URL url = RestServlet.class.getClassLoader().getResource(key);
                prop = new Properties();
                try {
                    if (key.endsWith(".xml")) {
                        prop.loadFromXML(url.openStream());
                        this.instances.put(key, prop);
                    } else if (key.endsWith(".properties")) {
                        prop.load(url.openStream());
                        this.instances.put(key, prop);
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, Properties> map = PropertiesLoader._instance.instances;
        synchronized (map) {
            PropertiesLoader._instance.instances.clear();
        }
    }
}

