/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppContext {
    private static ThreadLocal<AppContext> appContext = new ThreadLocal();
    private static Log log = LogFactory.getLog(AppContext.class);
    private HttpServletRequest req = null;
    private HttpServletResponse res = null;
    private boolean isMultiPart = false;
    private boolean isBinary = false;
    private List mixedList = null;

    public static AppContext getContext() {
        return appContext.get();
    }

    public static void setCurrentContext(AppContext context) {
        appContext.set(context);
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public String getRequestEncoding() {
        return this.req.getCharacterEncoding();
    }

    public void setResponseEncoding(String enc) {
        if (this.res.getCharacterEncoding() == null || !this.res.getCharacterEncoding().equals(enc)) {
            this.res.setCharacterEncoding(enc);
        }
    }

    public String getResponseEncoding() {
        return this.res.getCharacterEncoding();
    }

    public void setRequest(HttpServletRequest req) {
        this.req = req;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            try {
                this.isMultiPart = true;
                ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                fileUpload.setHeaderEncoding(this.getRequestEncoding());
                this.mixedList = fileUpload.parseRequest(req);
            }
            catch (FileUploadException e) {
                this.isMultiPart = false;
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setResponse(HttpServletResponse res) {
        this.res = res;
    }

    public String getParameter(String key) {
        String val = this.req.getParameter(key);
        if (!this.isMultiPart || val != null) {
            return val;
        }
        for (FileItem fItem : this.mixedList) {
            String name = fItem.getFieldName();
            if (name == null || !name.equals(key) || !fItem.isFormField()) continue;
            try {
                return fItem.getString(this.getRequestEncoding());
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return fItem.getString();
            }
        }
        return null;
    }

    public byte[] getBytes(String key) {
        if (!this.isMultiPart) {
            return null;
        }
        for (FileItem fItem : this.mixedList) {
            String name = fItem.getFieldName();
            if (name == null || !name.equals(key) || fItem.isFormField()) continue;
            return fItem.get();
        }
        return null;
    }

    public String[] getParameters(String key) {
        String[] vals = this.req.getParameterValues(key);
        if (!this.isMultiPart || vals != null && vals.length > 0) {
            return vals;
        }
        String[] returnObj = new String[1];
        for (FileItem fItem : this.mixedList) {
            String name = fItem.getFieldName();
            if (name == null || !name.equals(key) || !fItem.isFormField()) continue;
            try {
                returnObj[0] = fItem.getString(this.getRequestEncoding());
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                returnObj[0] = fItem.getString();
            }
            break;
        }
        return returnObj;
    }

    public boolean isMultipart() {
        return this.isMultiPart;
    }

    public void setIsBinary(boolean isBinary) {
        this.isBinary = isBinary;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void setContentType(String contentType) {
        this.res.setContentType(contentType);
    }
}

