/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.util;

import elazyrest.core.util.AppContext;
import elazyrest.core.util.ResponseGen;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JaxbUtil {
    private static Log log = LogFactory.getLog(JaxbUtil.class);

    public static String object2Xml(Object obj) {
        return JaxbUtil.object2Xml(obj, null);
    }

    public static String object2Xml(Object obj, String enc) {
        try {
            AppContext appContext = AppContext.getContext();
            if (enc == null) {
                enc = appContext.getResponseEncoding();
            }
            Class<?> cl = Class.forName(String.valueOf(obj.getClass().getPackage().getName()) + ".ObjectFactory");
            Object objectFactory = cl.newInstance();
            Class<?> targetClass = obj.getClass();
            Method createMethod = null;
            Method[] methods = cl.getMethods();
            String methodName = "";
            Method[] methodArray = methods;
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method method = methodArray[n];
                if (method.isAnnotationPresent(XmlElementDecl.class)) {
                    methodName = method.getName();
                    try {
                        createMethod = cl.getMethod(methodName, obj.getClass());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            JAXBElement el = (JAXBElement)createMethod.invoke(objectFactory, obj);
            JAXBContext jc = JAXBContext.newInstance((String)obj.getClass().getPackage().getName());
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)enc);
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            m.marshal((Object)el, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
    }

    public static String object2Html(Object obj, String xslt, String enc) {
        try {
            String xmlStr = JaxbUtil.object2Xml(obj, enc);
            TransformerFactory tf = TransformerFactory.newInstance();
            StringReader reader = new StringReader(xmlStr);
            StreamSource xmlSource = new StreamSource(reader);
            Thread currentThread = Thread.currentThread();
            StreamSource xslSource = new StreamSource(currentThread.getContextClassLoader().getResourceAsStream(xslt));
            StringWriter writer = new StringWriter();
            StreamResult sr = new StreamResult(writer);
            Transformer t = tf.newTransformer(xslSource);
            t.transform(xmlSource, sr);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(obj, enc);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(obj, enc);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return JaxbUtil.object2Xml(ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc"));
        }
    }
}

