/**
 * 
 */
package elazyrest.ext.hibernate;

import java.io.IOException;
import java.lang.annotation.Annotation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import elazyrest.core.aspect.AspectBase;
import elazyrest.core.aspect.AspectChain;


/**
 * @author kaz
 *
 */
public class HibernateAspect extends AspectBase {
	
	private static Log log = LogFactory.getLog(HibernateAspect.class);
	
	protected void afterService(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException{
		HibernateUse hibernateUse = (HibernateUse)methodAnnotation;
		if (hibernateUse.terminate()) {
			HibernateUtil.closeSession();
		}
	}

	protected void beforeService(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException{
	}

	protected void onException(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation, Exception e) throws IOException{
		HibernateUse hibernateUse = (HibernateUse)methodAnnotation;
		if (hibernateUse.terminate()) {
			//try {
				HibernateUtil.closeSession();
				//}
				//catch(SessionException se) {
				//log.error(se.getMessage(), se);
				//}
		}
	}
}
