#ifndef	__TESTCASE_H__
#define	__TESTCASE_H__

#include "Test.h"

typedef struct __TestCase	TestCase;
typedef struct __TestCase*	TestCaseRef;

struct __TestCase {
	TestInterface(TestCaseRef)
	void(*setUp)(void);
	void(*runTest)(void);
	void(*tearDown)(void);
};

void TestCase_run(TestCaseRef self,TestResultRef result);
int TestCase_countTestCases(TestCaseRef self);

#define new_TestCase(name,setUp,runTest,tearDown)	{\
														name,\
														TestCase_run,\
														TestCase_countTestCases,\
														setUp,\
														runTest,\
														tearDown,\
													}
#endif/*__TESTCASE_H__*/
