#include "config.h"
#include "stdImpl.h"
#include "TestResult.h"
#include "TestRunner.h"

static TestResult _result;

void TestRunner_startTest(TestListnerRef self,TestRef test)
{
	stdimpl_puts("\t");
	stdimpl_puts(test->name);
	stdimpl_puts("\n");
}

void TestRunner_endTest(TestListnerRef self,TestRef test)
{
}

void TestRunner_addFailure(TestListnerRef self,TestRef test,char *msg,int line,char *file)
{
	char buf[34];
	stdimpl_puts("\t");
	stdimpl_puts(file);
	stdimpl_puts(":");
	stdimpl_itoa(line, buf, 10);
	stdimpl_puts(buf);
	stdimpl_puts(" ");
	stdimpl_puts(msg);
	stdimpl_puts("\n");
}

const TestListner _listner = {
	TestRunner_startTest,
	TestRunner_endTest,
	TestRunner_addFailure,
};

void TestRunner_init(void)
{
	TestResult_result(&_result, (TestListnerRef)&_listner);
}

void TestRunner_runt(TestRef test)
{
	stdimpl_puts(test->name);
	stdimpl_puts(" :\n");
	test->run(test, &_result);
}

TestResultRef TestRunner_result(void)
{
	return (TestResultRef)&_result;
}

void TestRunner_printResult(void)
{
	if (_result.numberOfFailures) {
		char buf[34];
		stdimpl_puts("\nrun ");
		stdimpl_itoa(_result.numberOfTestsRun, buf, 10);
		stdimpl_puts(buf);
		stdimpl_puts(" failures ");
		stdimpl_itoa(_result.numberOfFailures, buf, 10);
		stdimpl_puts(buf);
		stdimpl_puts("\n");
	} else {
		char buf[34];
		stdimpl_puts("\nOK (");
		stdimpl_itoa(_result.numberOfTestsRun, buf, 10);
		stdimpl_puts(buf);
		stdimpl_puts(" tests)\n");
	}
}
