#include "TestCase.h"
#include "TestResult.h"

TestResultRef _result;
TestCaseRef _self;

void TestCase_run(TestCaseRef self,TestResultRef result)
{
	if (result) {
		result->startTest(result, (TestRef)self);
	}
	if (self->setUp) {
		self->setUp();
	}
	if (self->runTest) {
		TestResultRef wr =_result;	/*push*/
		TestCaseRef ws = _self;	/*push*/
		_result = result;
		_self = self;
		self->runTest();
		_result = wr;	/*pop*/
		_self = ws;	/*pop*/
	}
	if (self->tearDown) {
		self->tearDown();
	}
	if (result) {
		result->endTest(result, (TestRef)self);
	}
}

int TestCase_countTestCases(TestCaseRef testCase)
{
	return 1;
}

void addFailure(const char* msg, long line, const char* file)
{
	if (_result)
		_result->addFailure(_result, (TestRef)_self, (char*)msg, line, (char*)file);
}
