#ifndef	__TEST_H__
#define	__TEST_H__

typedef struct __TestResult		TestResult;
typedef struct __TestResult*	TestResultRef;

typedef struct __TestImplement	TestImplement;
typedef struct __TestImplement*	TestImplementRef;

typedef struct __Test	Test;
typedef struct __Test*	TestRef;

typedef char*(*TestImplName)(void*);
typedef void(*TestImplRun)(void*,TestResultRef);
typedef int(*TestImplCountTestCases)(void*);

struct __TestImplement {
	TestImplName name;
	TestImplRun run;
	TestImplCountTestCases countTestCases;
};

struct __Test {
	TestImplementRef isa;
};

#define Test_name(t)			(t)->isa->name(t)
#define Test_run(t,r)			(t)->isa->run(t,r)
#define Test_countTestCases(t)	(t)->isa->countTestCases(t)

#endif/*__TEST_H__*/
