#include "TestSuite.h"
#include "TestResult.h"

char* TestSuite_name(TestSuiteRef self)
{
	return self->name;
}

void TestSuite_run(TestSuiteRef self,TestResultRef result)
{
	int i;
	TestRef test;
	for (i=0; i<self->numberOfTests; i++) {
		test = self->tests[i];
		Test_run(test, result);
	}
}

int TestSuite_countTestCases(TestSuiteRef self)
{
	int count = 0;
	int i;
	TestRef test;
	for (i=0; i<self->numberOfTests; i++) {
		test = self->tests[i];
		count += Test_countTestCases(test);
	}
	return count;
}

const TestImplement TestSuiteImplement = {
	(TestImplName)TestSuite_name,
	(TestImplRun)TestSuite_run,
	(TestImplCountTestCases)TestSuite_countTestCases,
};
